/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.ext.servlet;

import com.noelios.restlet.local.Entity;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.servlet.ServletContext;
import org.restlet.Context;
import org.restlet.data.MediaType;
import org.restlet.resource.InputRepresentation;
import org.restlet.resource.Representation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletWarEntity
extends Entity {
    private List<Entity> children = null;
    private final boolean directory;
    private final String fullName;
    private final String path;
    private final ServletContext servletContext;

    public ServletWarEntity(ServletContext servletContext, String path) {
        this.servletContext = servletContext;
        this.path = path;
        if (path.endsWith("/")) {
            this.directory = true;
            this.fullName = path.substring(0, path.length() - 1);
            Set childPaths = this.getServletContext().getResourcePaths(path);
            if (childPaths != null && !childPaths.isEmpty()) {
                this.children = new ArrayList<Entity>();
                for (Object childPath : childPaths) {
                    if (childPath.equals(this.path)) continue;
                    this.children.add(new ServletWarEntity(this.servletContext, (String)childPath));
                }
            }
        } else {
            this.fullName = path;
            Set childPaths = this.getServletContext().getResourcePaths(path);
            if (childPaths != null && !childPaths.isEmpty()) {
                this.directory = true;
                this.children = new ArrayList<Entity>();
                for (Object childPath : childPaths) {
                    if (childPath.equals(this.path)) continue;
                    this.children.add(new ServletWarEntity(this.servletContext, (String)childPath));
                }
            } else {
                this.directory = false;
            }
        }
    }

    @Override
    public boolean exists() {
        boolean result = false;
        try {
            result = this.isDirectory() && this.getChildren() != null || this.isNormal() && this.getServletContext().getResource(this.path) != null;
        }
        catch (MalformedURLException e) {
            Context.getCurrentLogger().log(Level.WARNING, "Unable to test the existence of the WAR resource", e);
        }
        return result;
    }

    @Override
    public List<Entity> getChildren() {
        return this.children;
    }

    @Override
    public String getName() {
        int index = this.fullName.lastIndexOf("/");
        if (index != -1) {
            return this.fullName.substring(index + 1);
        }
        return this.fullName;
    }

    @Override
    public Entity getParent() {
        ServletWarEntity result = null;
        int index = this.fullName.lastIndexOf("/");
        if (index != -1) {
            result = new ServletWarEntity(this.getServletContext(), this.fullName.substring(0, index + 1));
        }
        return result;
    }

    @Override
    public Representation getRepresentation(MediaType defaultMediaType, int timeToLive) {
        InputStream ris = this.getServletContext().getResourceAsStream(this.path);
        return ris == null ? null : new InputRepresentation(ris, defaultMediaType);
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    @Override
    public boolean isDirectory() {
        return this.directory;
    }

    @Override
    public boolean isNormal() {
        return !this.isDirectory();
    }
}

