/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.ext.servlet;

import com.noelios.restlet.ext.servlet.ServletCall;
import com.noelios.restlet.ext.servlet.ServletLogger;
import com.noelios.restlet.http.HttpRequest;
import com.noelios.restlet.http.HttpResponse;
import com.noelios.restlet.http.HttpServerConverter;
import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.restlet.Context;
import org.restlet.Restlet;
import org.restlet.data.Reference;

public class ServletConverter
extends HttpServerConverter {
    private volatile Restlet target;

    public ServletConverter(ServletContext context) {
        this(context, null);
    }

    public ServletConverter(ServletContext context, Restlet target) {
        super(new Context(new ServletLogger(context)));
        this.target = target;
    }

    public Reference getBaseRef(HttpServletRequest request) {
        int baseIndex;
        Reference result = null;
        String basePath = request.getContextPath() + request.getServletPath();
        String baseUri = request.getRequestURL().toString();
        int pathStart = baseUri.indexOf("/", request.getScheme().length() + 3);
        if (basePath.length() == 0) {
            result = pathStart != -1 ? new Reference(baseUri.substring(0, pathStart)) : new Reference(baseUri);
        } else if (pathStart != -1 && (baseIndex = baseUri.indexOf(basePath, pathStart)) != -1) {
            result = new Reference(baseUri.substring(0, baseIndex + basePath.length()));
        }
        result.normalize();
        return result;
    }

    public Reference getRootRef(HttpServletRequest request) {
        return this.getBaseRef(request);
    }

    public Restlet getTarget() {
        return this.target;
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.getTarget() != null) {
            Context.setCurrent(this.getContext());
            ServletCall servletCall = new ServletCall(request.getLocalAddr(), request.getLocalPort(), request, response);
            HttpRequest httpRequest = this.toRequest(servletCall);
            HttpResponse httpResponse = new HttpResponse(servletCall, httpRequest);
            httpRequest.getResourceRef().setBaseRef(this.getBaseRef(request));
            httpRequest.setRootRef(this.getRootRef(request));
            this.getTarget().handle(httpRequest, httpResponse);
            this.commit(httpResponse);
        } else {
            this.getLogger().warning("Unable to find the Restlet target");
        }
    }

    public void setTarget(Restlet target) {
        this.target = target;
    }

    public HttpRequest toRequest(ServletCall servletCall) {
        HttpRequest result = super.toRequest(servletCall);
        Enumeration namesEnum = servletCall.getRequest().getAttributeNames();
        while (namesEnum.hasMoreElements()) {
            String attributeName = (String)namesEnum.nextElement();
            result.getAttributes().put(attributeName, servletCall.getRequest().getAttribute(attributeName));
        }
        return result;
    }
}

