/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.ext.servlet;

import com.noelios.restlet.http.HttpCall;
import com.noelios.restlet.http.HttpRequest;
import com.noelios.restlet.http.HttpServerCall;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.restlet.Server;
import org.restlet.data.Form;
import org.restlet.data.Parameter;
import org.restlet.data.Protocol;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletCall
extends HttpServerCall {
    private volatile HttpServletRequest request;
    private volatile Series<Parameter> requestHeaders;
    private volatile HttpServletResponse response;

    public static HttpServletRequest getRequest(Request request) {
        HttpCall httpCall;
        HttpServletRequest result = null;
        if (request instanceof HttpRequest && (httpCall = ((HttpRequest)request).getHttpCall()) instanceof ServletCall) {
            result = ((ServletCall)httpCall).getRequest();
        }
        return result;
    }

    public ServletCall(String serverAddress, int serverPort, HttpServletRequest request, HttpServletResponse response) {
        super(serverAddress, serverPort);
        this.request = request;
        this.response = response;
    }

    public ServletCall(Server server, HttpServletRequest request, HttpServletResponse response) {
        super(server);
        this.request = request;
        this.response = response;
    }

    @Override
    public String getClientAddress() {
        return this.getRequest().getRemoteAddr();
    }

    @Override
    public int getClientPort() {
        return this.getRequest().getRemotePort();
    }

    @Override
    public String getHostDomain() {
        return this.getRequest().getServerName();
    }

    @Override
    public String getMethod() {
        return this.getRequest().getMethod();
    }

    @Override
    public Protocol getProtocol() {
        return Protocol.valueOf(this.getRequest().getScheme());
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    @Override
    public ReadableByteChannel getRequestEntityChannel(long size) {
        return null;
    }

    @Override
    public InputStream getRequestEntityStream(long size) {
        try {
            return this.getRequest().getInputStream();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public ReadableByteChannel getRequestHeadChannel() {
        return null;
    }

    @Override
    public Series<Parameter> getRequestHeaders() {
        if (this.requestHeaders == null) {
            this.requestHeaders = new Form();
            Enumeration names = this.getRequest().getHeaderNames();
            while (names.hasMoreElements()) {
                String headerName = (String)names.nextElement();
                Enumeration values = this.getRequest().getHeaders(headerName);
                while (values.hasMoreElements()) {
                    String headerValue = (String)values.nextElement();
                    this.requestHeaders.add(new Parameter(headerName, headerValue));
                }
            }
        }
        return this.requestHeaders;
    }

    @Override
    public InputStream getRequestHeadStream() {
        return null;
    }

    @Override
    public String getRequestUri() {
        String queryString = this.getRequest().getQueryString();
        if (queryString == null || queryString.equals("")) {
            return this.getRequest().getRequestURI();
        }
        return this.getRequest().getRequestURI() + '?' + queryString;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    @Override
    public WritableByteChannel getResponseEntityChannel() {
        return null;
    }

    @Override
    public OutputStream getResponseEntityStream() {
        try {
            return this.getResponse().getOutputStream();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public String getServerAddress() {
        return this.getRequest().getLocalAddr();
    }

    @Override
    public int getServerPort() {
        return this.getRequest().getServerPort();
    }

    @Override
    public String getSslCipherSuite() {
        return (String)this.getRequest().getAttribute("javax.servlet.request.cipher_suite");
    }

    @Override
    public List<Certificate> getSslClientCertificates() {
        Certificate[] certificateArray = (Certificate[])this.getRequest().getAttribute("javax.servlet.request.X509Certificate");
        if (certificateArray != null) {
            return Arrays.asList(certificateArray);
        }
        return null;
    }

    @Override
    public Integer getSslKeySize() {
        Integer keySize = (Integer)this.getRequest().getAttribute("javax.servlet.request.key_size");
        if (keySize == null) {
            keySize = super.getSslKeySize();
        }
        return keySize;
    }

    @Override
    public String getVersion() {
        String result = null;
        int index = this.getRequest().getProtocol().indexOf(47);
        if (index != -1) {
            result = this.getRequest().getProtocol().substring(index + 1);
        }
        return result;
    }

    @Override
    public boolean isConfidential() {
        return this.getRequest().isSecure();
    }

    @Override
    public void sendResponse(Response response) throws IOException {
        if (Status.isError(this.getStatusCode()) && response.getEntity() == null) {
            try {
                for (Parameter header : this.getResponseHeaders()) {
                    if (header.getName().equals("Content-Length")) continue;
                    this.getResponse().addHeader(header.getName(), header.getValue());
                }
                this.getResponse().sendError(this.getStatusCode(), this.getReasonPhrase());
            }
            catch (IOException ioe) {
                this.getLogger().log(Level.WARNING, "Unable to set the response error status", ioe);
            }
        } else {
            this.getResponse().setStatus(this.getStatusCode());
            Parameter contentLengthHeader = null;
            for (Parameter header : this.getResponseHeaders()) {
                if (header.getName().equals("Content-Length")) {
                    contentLengthHeader = header;
                    continue;
                }
                this.getResponse().addHeader(header.getName(), header.getValue());
            }
            if (contentLengthHeader != null) {
                this.getResponse().addHeader(contentLengthHeader.getName(), contentLengthHeader.getValue());
            }
            super.sendResponse(response);
        }
    }
}

