/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.webresources.internal;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.web.ErrorStatusException;
import org.sonatype.nexus.web.WebResource;
import org.sonatype.nexus.web.WebUtils;
import org.sonatype.nexus.webresources.WebResourceService;
import org.sonatype.sisu.goodies.common.Time;

@Singleton
@Named
public class WebResourceServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(WebResourceServlet.class);
    private final WebResourceService webResources;
    private final WebUtils webUtils;
    private final long maxAgeSeconds;

    @Inject
    public WebResourceServlet(WebResourceService webResources, WebUtils webUtils, @Named(value="${nexus.webresources.maxAge:-30days}") Time maxAge) {
        this.webResources = (WebResourceService)Preconditions.checkNotNull((Object)webResources);
        this.webUtils = (WebUtils)Preconditions.checkNotNull((Object)webUtils);
        this.maxAgeSeconds = (Long)Preconditions.checkNotNull((Object)maxAge.toSeconds());
        log.info("Max-age: {} ({} seconds)", (Object)maxAge, (Object)this.maxAgeSeconds);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        WebResource resource;
        String path = request.getPathInfo();
        if ("".equals(path) || "/".equals(path)) {
            path = "/index.html";
        }
        if ((resource = this.webResources.getResource(path)) == null) {
            throw new ErrorStatusException(404, "Not Found", "Resource not found");
        }
        this.serveResource(resource, request, response);
    }

    private void serveResource(WebResource resource, HttpServletRequest request, HttpServletResponse response) throws IOException {
        log.trace("Serving resource: {}", (Object)resource);
        if (resource instanceof WebResource.Prepareable) {
            Preconditions.checkState(((resource = ((WebResource.Prepareable)resource).prepare()) != null ? 1 : 0) != 0, (Object)"Prepared resource is null");
        }
        assert (resource != null);
        String contentType = resource.getContentType();
        if (contentType == null) {
            contentType = "application/octet-stream";
        }
        response.setHeader("Content-Type", contentType);
        response.setDateHeader("Last-Modified", resource.getLastModified());
        long size = resource.getSize();
        if (size < 0L) {
            log.warn("Resource {} has invalid size: {}", (Object)resource.getPath(), (Object)size);
        }
        response.setHeader("Content-Length", String.valueOf(size));
        if (resource.isCacheable()) {
            response.setHeader("Cache-Control", "max-age=" + this.maxAgeSeconds);
        } else {
            this.webUtils.addNoCacheResponseHeaders(response);
        }
        long ifModifiedSince = request.getDateHeader("if-modified-since");
        if (ifModifiedSince > -1L && resource.getLastModified() <= ifModifiedSince) {
            response.setStatus(304);
        } else if ("GET".equalsIgnoreCase(request.getMethod())) {
            try (InputStream in = resource.getInputStream();){
                this.webUtils.sendContent(in, response);
            }
        }
    }
}

