/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.webresources.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.servlet.ServletContext;
import org.sonatype.nexus.internal.DevModeResources;
import org.sonatype.nexus.mime.MimeSupport;
import org.sonatype.nexus.plugin.support.FileWebResource;
import org.sonatype.nexus.plugin.support.UrlWebResource;
import org.sonatype.nexus.web.WebResource;
import org.sonatype.nexus.web.WebResourceBundle;
import org.sonatype.nexus.webresources.WebResourceService;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Singleton
@Named
public class WebResourceServiceImpl
extends ComponentSupport
implements WebResourceService {
    private final List<WebResourceBundle> bundles;
    private final List<WebResource> resources;
    private final Provider<ServletContext> servletContextProvider;
    private final MimeSupport mimeSupport;
    private final Map<String, WebResource> resourcePaths;

    @Inject
    public WebResourceServiceImpl(List<WebResourceBundle> bundles, List<WebResource> resources, @Named(value="nexus") Provider<ServletContext> servletContextProvider, MimeSupport mimeSupport) {
        this.bundles = (List)Preconditions.checkNotNull(bundles);
        this.resources = (List)Preconditions.checkNotNull(resources);
        this.servletContextProvider = (Provider)Preconditions.checkNotNull(servletContextProvider);
        this.mimeSupport = (MimeSupport)Preconditions.checkNotNull((Object)mimeSupport);
        this.resourcePaths = Maps.newHashMap();
        this.discoverResources();
    }

    private void discoverResources() {
        for (WebResourceBundle bundle : this.bundles) {
            List resources = bundle.getResources();
            if (resources == null) continue;
            for (WebResource resource : resources) {
                this.addResource(resource);
            }
        }
        for (WebResource resource : this.resources) {
            this.addResource(resource);
        }
        this.log.info("Discovered {} resources", (Object)this.resourcePaths.size());
        if (this.log.isDebugEnabled()) {
            ArrayList paths = Lists.newArrayList(this.resourcePaths.keySet());
            Collections.sort(paths);
            for (String path : paths) {
                this.log.debug("  {}", (Object)path);
            }
        }
        if (DevModeResources.hasResourceLocations()) {
            this.log.warn("DEV mode resources is ENABLED");
        }
    }

    private void addResource(WebResource resource) {
        String path = resource.getPath();
        this.log.trace("Adding resource: {} -> {}", (Object)path, (Object)resource);
        WebResource old = this.resourcePaths.put(path, resource);
        if (old != null) {
            this.log.debug("Overlapping resources on path {}: old={}, new={}", new Object[]{path, old, resource});
        }
    }

    @Override
    public Collection<String> getPaths() {
        return Collections.unmodifiableCollection(this.resourcePaths.keySet());
    }

    @Override
    public Collection<WebResource> getResources() {
        return Collections.unmodifiableCollection(this.resourcePaths.values());
    }

    @Override
    public WebResource getResource(String path) {
        this.log.trace("Looking up resource: {}", (Object)path);
        WebResource resource = null;
        File file = DevModeResources.getFileIfOnFileSystem((String)path);
        if (file != null) {
            resource = new FileWebResource(file, path, this.mimeSupport.guessMimeTypeFromPath(file.getName()), false);
            this.log.trace("Found dev-mode resource: {}", (Object)resource);
        }
        if (resource == null && (resource = this.resourcePaths.get(path)) != null) {
            this.log.trace("Found bound resource: {}", (Object)resource);
        }
        if (resource == null) {
            try {
                URL url = ((ServletContext)this.servletContextProvider.get()).getResource(path);
                if (url != null) {
                    resource = new UrlWebResource(url, path, this.mimeSupport.guessMimeTypeFromPath(path));
                    this.log.trace("Found servlet-context resource: {}", (Object)resource);
                }
            }
            catch (MalformedURLException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        return resource;
    }
}

