/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.sisu.goodies.lifecycle.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.sonatype.sisu.goodies.lifecycle.Lifecycle;
import org.sonatype.sisu.goodies.lifecycle.LifecycleAware;
import org.sonatype.sisu.goodies.lifecycle.LifecycleManager;
import org.sonatype.sisu.goodies.lifecycle.LifecycleSupport;

public class LifecycleManagerImpl
extends LifecycleSupport
implements LifecycleManager {
    private final List<Lifecycle> components = new CopyOnWriteArrayList<Lifecycle>();

    @Override
    public <T extends Lifecycle> T add(T component) {
        Preconditions.checkNotNull(component);
        if (!this.components.contains(component)) {
            this.components.add(component);
        }
        return component;
    }

    @Override
    public <T extends LifecycleAware> T add(T component) {
        Preconditions.checkNotNull(component);
        this.add((T)component.getLifecycle());
        return component;
    }

    @Override
    public LifecycleManager add(LifecycleAware ... components) {
        Preconditions.checkNotNull((Object)components);
        for (LifecycleAware component : components) {
            this.add((T)component);
        }
        return this;
    }

    @Override
    public <T extends Lifecycle> T remove(T component) {
        Preconditions.checkNotNull(component);
        this.components.remove(component);
        return component;
    }

    @Override
    public <T extends LifecycleAware> T remove(T component) {
        Preconditions.checkNotNull(component);
        this.remove((T)component.getLifecycle());
        return component;
    }

    @Override
    public LifecycleManager remove(LifecycleAware ... components) {
        Preconditions.checkNotNull((Object)components);
        for (LifecycleAware component : components) {
            this.remove((T)component);
        }
        return this;
    }

    @Override
    public void clear() {
        this.components.clear();
    }

    @Override
    protected void doStart() throws Exception {
        this.log.debug("Starting {} components", (Object)this.components.size());
        int failed = 0;
        for (Lifecycle component : this.components) {
            try {
                component.start();
            }
            catch (Exception e) {
                ++failed;
                this.log.error("Failed to start component: {}", (Object)component);
            }
        }
        if (failed != 0) {
            throw new Exception("Failed to start " + failed + " components");
        }
    }

    @Override
    protected void doStop() throws Exception {
        this.log.debug("Stopping {} components", (Object)this.components.size());
        int failed = 0;
        for (Lifecycle component : Lists.reverse(this.components)) {
            try {
                component.stop();
            }
            catch (Exception e) {
                ++failed;
                this.log.error("Failed to stop component: {}", (Object)component);
            }
        }
        if (failed != 0) {
            throw new Exception("Failed to stop " + failed + " components");
        }
    }
}

