/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.sisu.goodies.lifecycle;

import org.jetbrains.annotations.NonNls;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.sisu.goodies.lifecycle.Lifecycle;

public class Stopper {
    @NonNls
    private static final Logger log = LoggerFactory.getLogger(Stopper.class);

    private static void onFailure(Throwable cause) {
        log.warn(cause.toString(), cause);
    }

    public static void stop(Lifecycle ... targets) {
        if (targets == null) {
            return;
        }
        for (Lifecycle target : targets) {
            if (target == null) continue;
            log.trace("Stopping: {}", (Object)target);
            try {
                target.stop();
            }
            catch (Exception e) {
                Stopper.onFailure(e);
            }
        }
    }
}

