/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.sisu.goodies.lifecycle;

import org.jetbrains.annotations.NonNls;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.sisu.goodies.lifecycle.Lifecycle;

public class Starter {
    @NonNls
    private static final Logger log = LoggerFactory.getLogger(Starter.class);

    private static void onFailure(Throwable cause) {
        log.warn(cause.toString(), cause);
    }

    public static void start(Lifecycle ... targets) {
        if (targets == null) {
            return;
        }
        for (Lifecycle target : targets) {
            if (target == null) continue;
            log.trace("Starting: {}", (Object)target);
            try {
                target.start();
            }
            catch (Exception e) {
                Starter.onFailure(e);
            }
        }
    }
}

