/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.sisu.goodies.lifecycle;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import org.sonatype.gossip.Level;
import org.sonatype.sisu.goodies.common.ComponentSupport;
import org.sonatype.sisu.goodies.common.Mutex;
import org.sonatype.sisu.goodies.lifecycle.Lifecycle;
import org.sonatype.sisu.goodies.lifecycle.LifecycleHandler;
import org.sonatype.sisu.goodies.lifecycle.LifecycleHandlerContext;

public class LifecycleSupport
extends ComponentSupport
implements Lifecycle {
    private final Mutex lock = new Mutex();
    private final LifecycleHandlerContext state = new LifecycleHandlerContext(new Handler());

    protected Level getLifecycleLogLevel() {
        return Level.DEBUG;
    }

    @Override
    public Lifecycle getLifecycle() {
        return this;
    }

    protected void doFailed(Throwable cause) {
        this.log.error("Life-cycle operation failed", cause);
        throw Throwables.propagate((Throwable)cause);
    }

    protected boolean isResettable() {
        return false;
    }

    protected void doReset() throws Exception {
    }

    private void maybeFail() {
        if (this.state.getOwner().isFailed()) {
            this.state.fail();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void start() throws Exception {
        Mutex mutex = this.lock;
        synchronized (mutex) {
            this.state.start();
            this.state.started();
            this.maybeFail();
        }
    }

    protected void doStart() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void stop() throws Exception {
        Mutex mutex = this.lock;
        synchronized (mutex) {
            this.state.stop();
            this.state.stopped();
            this.maybeFail();
        }
    }

    protected void doStop() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isStarted() {
        Mutex mutex = this.lock;
        synchronized (mutex) {
            return ((Object)((Object)this.state.getState())).equals((Object)LifecycleHandlerContext.MainMap.Started);
        }
    }

    protected void ensureStarted() {
        Preconditions.checkState((boolean)this.isStarted(), (Object)"Not started");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isStopped() {
        Mutex mutex = this.lock;
        synchronized (mutex) {
            return ((Object)((Object)this.state.getState())).equals((Object)LifecycleHandlerContext.MainMap.Stopped);
        }
    }

    protected void ensureStopped() {
        Preconditions.checkState((boolean)this.isStopped(), (Object)"Not stopped");
    }

    private final class Handler
    implements LifecycleHandler {
        private final LifecycleSupport owner;
        private Throwable failure;

        private Handler() {
            this.owner = LifecycleSupport.this;
        }

        @Override
        public void log(String message) {
            LifecycleSupport.this.getLifecycleLogLevel().log(LifecycleSupport.this.log, message);
        }

        @Override
        public boolean isFailed() {
            return this.failure != null;
        }

        @Override
        public boolean isResettable() {
            return this.owner.isResettable();
        }

        @Override
        public void doFailed() {
            if (this.failure != null) {
                this.owner.doFailed(this.failure);
            }
        }

        @Override
        public void doStart() {
            try {
                this.owner.doStart();
            }
            catch (Throwable e) {
                this.failure = e;
            }
        }

        @Override
        public void doStop() {
            try {
                this.owner.doStop();
            }
            catch (Throwable e) {
                this.failure = e;
            }
        }

        @Override
        public void doReset() {
            this.failure = null;
            try {
                this.owner.doReset();
            }
            catch (Throwable e) {
                this.failure = e;
            }
        }
    }
}

