/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.sisu.goodies.lifecycle;

import org.slf4j.Logger;
import org.sonatype.sisu.goodies.common.ComponentSupport;
import org.sonatype.sisu.goodies.common.Mutex;
import org.sonatype.sisu.goodies.lifecycle.LifecycleAware;
import org.sonatype.sisu.goodies.lifecycle.LifecycleContainer;
import org.sonatype.sisu.goodies.lifecycle.LifecycleManager;
import org.sonatype.sisu.goodies.lifecycle.Starter;
import org.sonatype.sisu.goodies.lifecycle.internal.LifecycleManagerImpl;

public class LifecycleShutdownManager
extends ComponentSupport
implements LifecycleContainer {
    private final Mutex lock = new Mutex();
    private final ShutdownHook hook = new ShutdownHook();
    private final LifecycleManager lifecycles = new LifecycleManagerImpl(){

        protected Logger createLogger() {
            return LifecycleShutdownManager.this.log;
        }
    };
    private int count = 0;
    private boolean installed = false;

    public LifecycleShutdownManager() {
        Starter.start(this.lifecycles);
    }

    private void install() {
        if (this.installed || this.count != 1) {
            return;
        }
        this.log.debug("Installing hook");
        Runtime.getRuntime().addShutdownHook(this.hook);
        this.installed = true;
    }

    private void remove() {
        if (!this.installed || this.count != 0) {
            return;
        }
        this.log.debug("Removing hook");
        Runtime.getRuntime().removeShutdownHook(this.hook);
        this.installed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends LifecycleAware> T add(T component) {
        Mutex mutex = this.lock;
        synchronized (mutex) {
            T value = this.lifecycles.add(component);
            ++this.count;
            this.install();
            return value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LifecycleShutdownManager add(LifecycleAware ... components) {
        Mutex mutex = this.lock;
        synchronized (mutex) {
            this.lifecycles.add(components);
            ++this.count;
            this.install();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends LifecycleAware> T remove(T component) {
        Mutex mutex = this.lock;
        synchronized (mutex) {
            T value = this.lifecycles.remove(component);
            --this.count;
            this.remove();
            return value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LifecycleShutdownManager remove(LifecycleAware ... components) {
        Mutex mutex = this.lock;
        synchronized (mutex) {
            this.lifecycles.remove(components);
            --this.count;
            this.remove();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Mutex mutex = this.lock;
        synchronized (mutex) {
            this.lifecycles.clear();
            this.count = 0;
            this.remove();
        }
    }

    private class ShutdownHook
    extends Thread {
        public ShutdownHook() {
            this.setName(this.getClass().getSimpleName());
        }

        @Override
        public void run() {
            try {
                LifecycleShutdownManager.this.lifecycles.stop();
            }
            catch (Exception e) {
                LifecycleShutdownManager.this.log.error("Stop failed", (Throwable)e);
            }
        }
    }
}

