/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.sisu.goodies.lifecycle;

import org.sonatype.sisu.goodies.lifecycle.LifecycleHandler;
import statemap.FSMContext;
import statemap.State;
import statemap.StateUndefinedException;
import statemap.TransitionUndefinedException;

public class LifecycleHandlerContext
extends FSMContext {
    private transient LifecycleHandler _owner;

    public LifecycleHandlerContext(LifecycleHandler owner) {
        super((State)MainMap.Stopped);
        this._owner = owner;
    }

    public LifecycleHandlerContext(LifecycleHandler owner, LifecycleHandlerState initState) {
        super((State)initState);
        this._owner = owner;
    }

    public synchronized void enterStartState() {
        this.getState().Entry(this);
    }

    public synchronized void fail() {
        this._transition = "fail";
        this.getState().fail(this);
        this._transition = "";
    }

    public synchronized void start() {
        this._transition = "start";
        this.getState().start(this);
        this._transition = "";
    }

    public synchronized void started() {
        this._transition = "started";
        this.getState().started(this);
        this._transition = "";
    }

    public synchronized void stop() {
        this._transition = "stop";
        this.getState().stop(this);
        this._transition = "";
    }

    public synchronized void stopped() {
        this._transition = "stopped";
        this.getState().stopped(this);
        this._transition = "";
    }

    public LifecycleHandlerState getState() throws StateUndefinedException {
        if (this._state == null) {
            throw new StateUndefinedException();
        }
        return (LifecycleHandlerState)this._state;
    }

    protected LifecycleHandler getOwner() {
        return this._owner;
    }

    public void setOwner(LifecycleHandler owner) {
        if (owner == null) {
            throw new NullPointerException("null owner");
        }
        this._owner = owner;
    }

    private static final class MainMap_Failed
    extends MainMap_Default {
        private MainMap_Failed(String name, int id) {
            super(name, id);
        }

        @Override
        protected void Entry(LifecycleHandlerContext context) {
            LifecycleHandler ctxt = context.getOwner();
            ctxt.log("Failed");
            ctxt.doFailed();
        }

        @Override
        protected void fail(LifecycleHandlerContext context) {
            context.getState().Exit(context);
            context.setState(MainMap.Failed);
            context.getState().Entry(context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void start(LifecycleHandlerContext context) {
            LifecycleHandler ctxt = context.getOwner();
            if (ctxt.isResettable()) {
                context.getState().Exit(context);
                context.clearState();
                try {
                    ctxt.doReset();
                }
                finally {
                    context.setState(MainMap.Starting);
                    context.getState().Entry(context);
                }
            } else {
                super.start(context);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void stop(LifecycleHandlerContext context) {
            LifecycleHandler ctxt = context.getOwner();
            if (ctxt.isResettable()) {
                context.getState().Exit(context);
                context.clearState();
                try {
                    ctxt.doReset();
                }
                finally {
                    context.setState(MainMap.Stopping);
                    context.getState().Entry(context);
                }
            } else {
                super.stop(context);
            }
        }
    }

    private static final class MainMap_Stopped
    extends MainMap_Default {
        private MainMap_Stopped(String name, int id) {
            super(name, id);
        }

        @Override
        protected void Entry(LifecycleHandlerContext context) {
            LifecycleHandler ctxt = context.getOwner();
            ctxt.log("Stopped");
        }

        @Override
        protected void fail(LifecycleHandlerContext context) {
            context.getState().Exit(context);
            context.setState(MainMap.Failed);
            context.getState().Entry(context);
        }

        @Override
        protected void start(LifecycleHandlerContext context) {
            context.getState().Exit(context);
            context.setState(MainMap.Starting);
            context.getState().Entry(context);
        }
    }

    private static final class MainMap_Stopping
    extends MainMap_Default {
        private MainMap_Stopping(String name, int id) {
            super(name, id);
        }

        @Override
        protected void Entry(LifecycleHandlerContext context) {
            LifecycleHandler ctxt = context.getOwner();
            ctxt.log("Stopping");
        }

        @Override
        protected void fail(LifecycleHandlerContext context) {
            context.getState().Exit(context);
            context.setState(MainMap.Failed);
            context.getState().Entry(context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void stopped(LifecycleHandlerContext context) {
            LifecycleHandler ctxt = context.getOwner();
            context.getState().Exit(context);
            context.clearState();
            try {
                ctxt.doStop();
            }
            finally {
                context.setState(MainMap.Stopped);
                context.getState().Entry(context);
            }
        }
    }

    private static final class MainMap_Started
    extends MainMap_Default {
        private MainMap_Started(String name, int id) {
            super(name, id);
        }

        @Override
        protected void Entry(LifecycleHandlerContext context) {
            LifecycleHandler ctxt = context.getOwner();
            ctxt.log("Started");
        }

        @Override
        protected void fail(LifecycleHandlerContext context) {
            context.getState().Exit(context);
            context.setState(MainMap.Failed);
            context.getState().Entry(context);
        }

        @Override
        protected void stop(LifecycleHandlerContext context) {
            context.getState().Exit(context);
            context.setState(MainMap.Stopping);
            context.getState().Entry(context);
        }
    }

    private static final class MainMap_Starting
    extends MainMap_Default {
        private MainMap_Starting(String name, int id) {
            super(name, id);
        }

        @Override
        protected void Entry(LifecycleHandlerContext context) {
            LifecycleHandler ctxt = context.getOwner();
            ctxt.log("Starting");
        }

        @Override
        protected void fail(LifecycleHandlerContext context) {
            context.getState().Exit(context);
            context.setState(MainMap.Failed);
            context.getState().Entry(context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void started(LifecycleHandlerContext context) {
            LifecycleHandler ctxt = context.getOwner();
            context.getState().Exit(context);
            context.clearState();
            try {
                ctxt.doStart();
            }
            finally {
                context.setState(MainMap.Started);
                context.getState().Entry(context);
            }
        }
    }

    protected static class MainMap_Default
    extends LifecycleHandlerState {
        protected MainMap_Default(String name, int id) {
            super(name, id);
        }
    }

    static abstract class MainMap {
        public static final MainMap_Starting Starting = new MainMap_Starting("MainMap.Starting", 0);
        public static final MainMap_Started Started = new MainMap_Started("MainMap.Started", 1);
        public static final MainMap_Stopping Stopping = new MainMap_Stopping("MainMap.Stopping", 2);
        public static final MainMap_Stopped Stopped = new MainMap_Stopped("MainMap.Stopped", 3);
        public static final MainMap_Failed Failed = new MainMap_Failed("MainMap.Failed", 4);
        private static final MainMap_Default Default = new MainMap_Default("MainMap.Default", -1);

        MainMap() {
        }
    }

    public static abstract class LifecycleHandlerState
    extends State {
        protected LifecycleHandlerState(String name, int id) {
            super(name, id);
        }

        protected void Entry(LifecycleHandlerContext context) {
        }

        protected void Exit(LifecycleHandlerContext context) {
        }

        protected void fail(LifecycleHandlerContext context) {
            this.Default(context);
        }

        protected void start(LifecycleHandlerContext context) {
            this.Default(context);
        }

        protected void started(LifecycleHandlerContext context) {
            this.Default(context);
        }

        protected void stop(LifecycleHandlerContext context) {
            this.Default(context);
        }

        protected void stopped(LifecycleHandlerContext context) {
            this.Default(context);
        }

        protected void Default(LifecycleHandlerContext context) {
            throw new TransitionUndefinedException("State: " + context.getState().getName() + ", Transition: " + context.getTransition());
        }
    }
}

