/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.bootstrap.monitor;

import java.io.IOException;
import java.net.ConnectException;
import org.sonatype.nexus.bootstrap.ShutdownHelper;
import org.sonatype.nexus.bootstrap.monitor.CommandMonitorTalker;

public class KeepAliveThread
extends Thread {
    public static final String KEEP_ALIVE_PORT = KeepAliveThread.class.getName() + ".port";
    public static final String KEEP_ALIVE_PING_INTERVAL = KeepAliveThread.class.getName() + ".pingInterval";
    public static final String KEEP_ALIVE_TIMEOUT = KeepAliveThread.class.getName() + ".timeout";
    private final CommandMonitorTalker talker;
    private final int interval;
    private final int timeout;
    private final Runnable task;
    private volatile boolean running;

    public KeepAliveThread(String host, int port, int interval, int timeout, Runnable task) throws IOException {
        this.setDaemon(true);
        this.setName(this.getClass().getName());
        this.talker = new CommandMonitorTalker(host, port);
        this.interval = interval;
        this.timeout = timeout;
        this.task = task;
        this.running = true;
    }

    public KeepAliveThread(String host, int port, int interval, int timeout) throws IOException {
        this(host, port, interval, timeout, new Runnable(){

            @Override
            public void run() {
                ShutdownHelper.halt(666);
            }
        });
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                try {
                    this.ping();
                    KeepAliveThread.sleep(this.interval);
                }
                catch (InterruptedException e) {
                    this.ping();
                }
            }
            catch (ConnectException e) {
                this.stopRunning();
                this.executeTask();
            }
        }
    }

    private void ping() throws ConnectException {
        try {
            this.talker.send("PING", this.timeout);
        }
        catch (ConnectException e) {
            throw e;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void executeTask() {
        this.task.run();
    }

    public void stopRunning() {
        this.running = false;
    }
}

