/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.bootstrap.monitor;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import org.sonatype.nexus.bootstrap.log.LogProxy;

public class CommandMonitorThread
extends Thread {
    public static final String LOCALHOST = "127.0.0.1";
    private static final LogProxy log = LogProxy.getLogger(CommandMonitorThread.class);
    private final ServerSocket socket;
    private final Map<String, Command> commands = new HashMap<String, Command>();

    public CommandMonitorThread(int port, Command ... commands) throws IOException {
        this.setDaemon(true);
        if (commands != null) {
            for (Command command : commands) {
                this.commands.put(command.getId(), command);
            }
        }
        this.setDaemon(true);
        this.setName("Bootstrap Command Monitor");
        this.socket = new ServerSocket(port, 1, InetAddress.getByName(LOCALHOST));
    }

    @Override
    public void run() {
        log.debug("Listening for commands: {}", this.socket);
        boolean running = true;
        while (running) {
            try {
                Command command;
                Socket client = this.socket.accept();
                log.debug("Accepted client: {}", client);
                BufferedReader reader = new BufferedReader(new InputStreamReader(client.getInputStream()));
                String commandId = reader.readLine();
                log.debug("Read command: {}", commandId);
                client.close();
                if (commandId == null) {
                    commandId = "PING";
                }
                if ((command = this.commands.get(commandId)) == null) {
                    log.error("Unknown command: {}", commandId);
                    continue;
                }
                running = !command.execute();
            }
            catch (Exception e) {
                log.error("Failed", e);
            }
        }
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        log.debug("Stopped", new Object[0]);
    }

    public int getPort() {
        return this.socket.getLocalPort();
    }

    public static interface Command {
        public String getId();

        public boolean execute();
    }
}

