/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.bootstrap.log;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.sonatype.nexus.bootstrap.log.LogProxy;

public class SystemOutLogProxy
extends LogProxy {
    private Class clazz;

    public SystemOutLogProxy(Class clazz) {
        this.clazz = clazz;
    }

    @Override
    public void debug(String message, Object ... args) {
        this.message("DEBUG", message, args);
    }

    @Override
    public void info(String message, Object ... args) {
        this.message("INFO", message, args);
    }

    @Override
    public void error(String message, Throwable e) {
        this.error(message, new Object[0]);
        e.printStackTrace(System.out);
    }

    @Override
    public void error(String message, Object ... args) {
        this.message("ERROR", message, args);
    }

    @Override
    public void warn(String message, Object ... args) {
        this.message("WARN", message, args);
    }

    private void message(String level, String message, Object ... args) {
        String timestamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
        System.out.println(timestamp + " [" + level + "] " + this.clazz.getSimpleName() + " - " + String.format(message.replace("{}", "%s"), args));
    }
}

