/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.bootstrap.jsw;

import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tanukisoftware.wrapper.WrapperListener;

public abstract class WrapperListenerSupport
implements WrapperListener {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    public Integer start(String[] args) {
        this.log.info("Starting with arguments: {}", Arrays.asList(args));
        try {
            return this.doStart(args);
        }
        catch (Exception e) {
            this.log.error("Failed to start", (Throwable)e);
            return 1;
        }
    }

    protected abstract Integer doStart(String[] var1) throws Exception;

    public int stop(int code) {
        this.log.info("Stopping with code: {}", (Object)code);
        try {
            return this.doStop(code);
        }
        catch (Exception e) {
            this.log.error("Failed to stop cleanly", (Throwable)e);
            return 1;
        }
    }

    protected abstract int doStop(int var1) throws Exception;

    public void controlEvent(int code) {
        this.log.info("Received control event: {}", (Object)code);
        try {
            this.doControlEvent(code);
        }
        catch (Exception e) {
            this.log.error("Failed to handle control event[{}]", (Object)code, (Object)e);
        }
    }

    protected abstract void doControlEvent(int var1) throws Exception;
}

