/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.bootstrap.jsw;

import org.slf4j.MDC;
import org.sonatype.nexus.bootstrap.Launcher;
import org.sonatype.nexus.bootstrap.ShutdownHelper;
import org.sonatype.nexus.bootstrap.jsw.JswShutdownDelegate;
import org.sonatype.nexus.bootstrap.jsw.WrapperListenerSupport;
import org.tanukisoftware.wrapper.WrapperListener;
import org.tanukisoftware.wrapper.WrapperManager;
import org.tanukisoftware.wrapper.WrapperUser;

public class JswLauncher
extends WrapperListenerSupport {
    private Launcher launcher;

    @Override
    protected Integer doStart(String[] args) throws Exception {
        if (WrapperManager.isControlledByNativeWrapper()) {
            String username = "*UNKNOWN";
            WrapperUser user = WrapperManager.getUser((boolean)false);
            if (user != null) {
                username = user.getUser();
            } else {
                this.log.warn("Failed to query native user details, local environment may have problems using JSW functionality");
            }
            this.log.info("JVM ID: {}, JVM PID: {}, Wrapper PID: {}, User: {}", new Object[]{WrapperManager.getJVMId(), WrapperManager.getJavaPID(), WrapperManager.getWrapperPID(), username});
        }
        this.launcher = new Launcher(null, null, args){

            @Override
            public void commandStop() {
                WrapperManager.stopAndReturn((int)0);
            }
        };
        this.launcher.start();
        return null;
    }

    @Override
    protected int doStop(int code) throws Exception {
        this.launcher.stop();
        return code;
    }

    @Override
    protected void doControlEvent(int code) {
        if (202 != code || !WrapperManager.isLaunchedAsService()) {
            this.log.debug("Stopping");
            WrapperManager.stop((int)0);
            throw new Error("unreachable");
        }
        this.log.debug("Launched as a service; ignoring event: {}", (Object)code);
    }

    public static void main(String[] args) throws Exception {
        MDC.put((String)"userId", (String)"*SYSTEM");
        ShutdownHelper.setDelegate(new JswShutdownDelegate());
        WrapperManager.start((WrapperListener)new JswLauncher(), (String[])args);
    }
}

