/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.bootstrap.jetty;

import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.xml.XmlConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.bootstrap.PropertyMap;

public class JettyServer {
    private static final Logger log = LoggerFactory.getLogger(JettyServer.class);
    private final ClassLoader classLoader;
    private final Map<String, String> properties;
    private final String[] args;
    private JettyMainThread thread;

    public JettyServer(ClassLoader classLoader, Map<String, String> properties, String[] args) {
        if (classLoader == null) {
            throw new NullPointerException();
        }
        this.classLoader = classLoader;
        if (properties == null) {
            throw new NullPointerException();
        }
        this.properties = properties;
        if (args == null) {
            throw new NullPointerException();
        }
        this.args = args;
    }

    private Exception propagateThrowable(Throwable e) throws Exception {
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        if (e instanceof Exception) {
            throw (Exception)e;
        }
        if (e instanceof Error) {
            throw (Error)e;
        }
        throw new Error(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start() throws Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.classLoader);
        try {
            final AtomicReference exception = new AtomicReference();
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    try {
                        JettyServer.this.doStart();
                    }
                    catch (Exception e) {
                        exception.set(e);
                    }
                    return null;
                }
            });
            Throwable e = (Throwable)exception.get();
            if (e != null) {
                log.error("Start failed", e);
                throw this.propagateThrowable(e);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    private void doStart() throws Exception {
        if (this.thread != null) {
            throw new IllegalStateException("Already started");
        }
        log.info("Starting");
        ArrayList<LifeCycle> components = new ArrayList<LifeCycle>();
        PropertyMap props = new PropertyMap();
        props.putAll(this.properties);
        XmlConfiguration last = null;
        for (String arg : this.args) {
            Object component;
            URL url = Resource.newResource((String)arg).getURL();
            if (url.getFile().toLowerCase(Locale.ENGLISH).endsWith(".properties")) {
                log.info("Loading properties: {}", (Object)url);
                props.load(url);
                continue;
            }
            log.info("Applying configuration: {}", (Object)url);
            XmlConfiguration configuration = new XmlConfiguration(url);
            if (last != null) {
                configuration.getIdMap().putAll(last.getIdMap());
            }
            if (!props.isEmpty()) {
                configuration.getProperties().putAll(props);
            }
            if ((component = configuration.configure()) instanceof LifeCycle) {
                components.add((LifeCycle)component);
            }
            last = configuration;
        }
        if (components.isEmpty()) {
            throw new Exception("Failed to configure any components");
        }
        this.thread = new JettyMainThread(components);
        this.thread.setContextClassLoader(this.classLoader);
        this.thread.startComponents();
        log.info("Started");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() throws Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.classLoader);
        try {
            final AtomicReference exception = new AtomicReference();
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    try {
                        JettyServer.this.doStop();
                    }
                    catch (Exception e) {
                        exception.set(e);
                    }
                    return null;
                }
            });
            Throwable e = (Throwable)exception.get();
            if (e != null) {
                log.error("Stop failed", e);
                throw this.propagateThrowable(e);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    private void doStop() throws Exception {
        if (this.thread == null) {
            throw new IllegalStateException("Not started");
        }
        log.info("Stopping");
        this.thread.stopComponents();
        this.thread = null;
        log.info("Stopped");
    }

    private static class JettyMainThread
    extends Thread {
        private static final AtomicInteger INSTANCE_COUNTER = new AtomicInteger(1);
        private final List<LifeCycle> components;
        private final CountDownLatch started;
        private final CountDownLatch stopped;
        private volatile Exception exception;

        public JettyMainThread(List<LifeCycle> components) {
            super("jetty-main-" + INSTANCE_COUNTER.getAndIncrement());
            this.components = components;
            this.started = new CountDownLatch(1);
            this.stopped = new CountDownLatch(1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Server server = null;
                try {
                    for (LifeCycle component : this.components) {
                        if (component instanceof Server) {
                            server = (Server)component;
                        }
                        if (component.isRunning()) continue;
                        log.info("Starting: {}", (Object)component);
                        component.start();
                    }
                }
                catch (Exception e) {
                    this.exception = e;
                }
                finally {
                    this.started.countDown();
                }
                if (server != null) {
                    log.info("Running");
                    server.join();
                }
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.stopped.countDown();
            }
        }

        public void startComponents() throws Exception {
            this.start();
            this.started.await();
            if (this.exception != null) {
                throw this.exception;
            }
        }

        public void stopComponents() throws Exception {
            Collections.reverse(this.components);
            for (LifeCycle component : this.components) {
                if (!component.isRunning()) continue;
                log.info("Stopping: {}", (Object)component);
                component.stop();
            }
            this.components.clear();
            this.stopped.await();
        }
    }
}

