/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.bootstrap.jetty;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricsRegistry;
import com.yammer.metrics.core.Timer;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InstrumentedSelectChannelConnector
extends SelectChannelConnector {
    private static final Logger log = LoggerFactory.getLogger(InstrumentedSelectChannelConnector.class);
    private final MetricsRegistry registry = Metrics.defaultRegistry();
    private Timer duration;
    private Meter accepts;
    private Meter connects;
    private Meter disconnects;
    private Counter connections;

    protected void doStart() throws Exception {
        String port = String.valueOf(this.getPort());
        this.duration = this.registry.newTimer(SelectChannelConnector.class, "connection-duration", port, TimeUnit.MILLISECONDS, TimeUnit.SECONDS);
        this.accepts = this.registry.newMeter(SelectChannelConnector.class, "accepts", port, "connections", TimeUnit.SECONDS);
        this.connects = this.registry.newMeter(SelectChannelConnector.class, "connects", port, "connections", TimeUnit.SECONDS);
        this.disconnects = this.registry.newMeter(SelectChannelConnector.class, "disconnects", port, "connections", TimeUnit.SECONDS);
        this.connections = this.registry.newCounter(SelectChannelConnector.class, "active-connections", port);
        log.info("Metrics enabled");
        super.doStart();
    }

    public void accept(int acceptorID) throws IOException {
        super.accept(acceptorID);
        this.accepts.mark();
    }

    protected void connectionOpened(Connection connection) {
        this.connections.inc();
        super.connectionOpened(connection);
        this.connects.mark();
    }

    protected void connectionClosed(Connection connection) {
        super.connectionClosed(connection);
        this.disconnects.mark();
        long duration = System.currentTimeMillis() - connection.getTimeStamp();
        this.duration.update(duration, TimeUnit.MILLISECONDS);
        this.connections.dec();
    }
}

