/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.bootstrap;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class TemporaryDirectory {
    public static final String PROPERTY = "java.io.tmpdir";

    public static File get() throws IOException {
        String location = System.getProperty(PROPERTY, "tmp");
        File dir = new File(location).getCanonicalFile();
        TemporaryDirectory.mkdir(dir);
        Path file = Files.createTempFile("nexus-tmpdir", ".tmp", new FileAttribute[0]);
        Files.delete(file);
        return dir;
    }

    private static void mkdir(File dir) throws IOException {
        block2: {
            try {
                Files.createDirectories(dir.toPath(), new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException e) {
                if (Files.isDirectory(dir.toPath(), new LinkOption[0])) break block2;
                throw new IOException("Unable to create java.io.tmpdir: " + dir, e);
            }
        }
    }
}

