/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.bootstrap;

public class ShutdownHelper {
    private static ShutdownDelegate delegate = new JavaShutdownDelegate();

    public static ShutdownDelegate getDelegate() {
        if (delegate == null) {
            throw new IllegalStateException();
        }
        return delegate;
    }

    public static void setDelegate(ShutdownDelegate delegate) {
        if (delegate == null) {
            throw new NullPointerException();
        }
        ShutdownHelper.delegate = delegate;
    }

    public static void exit(int code) {
        ShutdownHelper.getDelegate().doExit(code);
    }

    public static void halt(int code) {
        ShutdownHelper.getDelegate().doHalt(code);
    }

    public static class JavaShutdownDelegate
    implements ShutdownDelegate {
        @Override
        public void doExit(int code) {
            System.exit(code);
        }

        @Override
        public void doHalt(int code) {
            Runtime.getRuntime().halt(code);
        }
    }

    public static interface ShutdownDelegate {
        public void doExit(int var1);

        public void doHalt(int var1);
    }
}

