/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.bootstrap;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.slf4j.bridge.SLF4JBridgeHandler;
import org.sonatype.nexus.bootstrap.ConfigurationBuilder;
import org.sonatype.nexus.bootstrap.ConfigurationHolder;
import org.sonatype.nexus.bootstrap.EnvironmentVariables;
import org.sonatype.nexus.bootstrap.ShutdownHelper;
import org.sonatype.nexus.bootstrap.TemporaryDirectory;
import org.sonatype.nexus.bootstrap.jetty.JettyServer;
import org.sonatype.nexus.bootstrap.monitor.CommandMonitorThread;
import org.sonatype.nexus.bootstrap.monitor.KeepAliveThread;
import org.sonatype.nexus.bootstrap.monitor.commands.ExitCommand;
import org.sonatype.nexus.bootstrap.monitor.commands.HaltCommand;
import org.sonatype.nexus.bootstrap.monitor.commands.PingCommand;
import org.sonatype.nexus.bootstrap.monitor.commands.StopApplicationCommand;

public class Launcher {
    public static final String COMMAND_MONITOR_PORT = CommandMonitorThread.class.getName() + ".port";
    public static final String SYSTEM_USERID = "*SYSTEM";
    private static final String FIVE_SECONDS = "5000";
    private static final String ONE_SECOND = "1000";
    private final JettyServer server;

    public Launcher(@Nullable ClassLoader classLoader, @Nullable Map<String, String> overrides, String[] args) throws Exception {
        if (args == null) {
            throw new NullPointerException();
        }
        if (args.length == 0) {
            throw new IllegalArgumentException("Missing args");
        }
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
        ClassLoader cl = classLoader == null ? this.getClass().getClassLoader() : classLoader;
        ConfigurationBuilder builder = new ConfigurationBuilder().defaults().set("bundleBasedir", new File(".").getCanonicalPath()).properties("/nexus.properties", true).properties("/nexus-test.properties", false).custom(new EnvironmentVariables()).override(System.getProperties());
        if (overrides != null) {
            builder.properties(overrides);
        }
        Map<String, String> props = builder.build();
        System.getProperties().putAll(props);
        ConfigurationHolder.set(props);
        Logger log = LoggerFactory.getLogger(Launcher.class);
        log.info("Java: {}, {}, {}, {}", new Object[]{System.getProperty("java.version"), System.getProperty("java.vm.name"), System.getProperty("java.vm.vendor"), System.getProperty("java.vm.version")});
        log.info("OS: {}, {}, {}", new Object[]{System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch")});
        log.info("User: {}, {}, {}", new Object[]{System.getProperty("user.name"), System.getProperty("user.language"), System.getProperty("user.home")});
        log.info("CWD: {}", (Object)System.getProperty("user.dir"));
        File tmpdir = TemporaryDirectory.get();
        log.info("TMP: {}", (Object)tmpdir);
        this.server = new JettyServer(cl, props, args);
    }

    public void start() throws Exception {
        this.maybeEnableCommandMonitor();
        this.maybeEnableShutdownIfNotAlive();
        this.server.start();
    }

    private String getProperty(String name, String defaultValue) {
        String value = System.getProperty(name, System.getenv(name));
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    private void maybeEnableCommandMonitor() throws IOException {
        String port = this.getProperty(COMMAND_MONITOR_PORT, null);
        if (port != null) {
            new CommandMonitorThread(Integer.parseInt(port), new StopApplicationCommand(new Runnable(){

                @Override
                public void run() {
                    Launcher.this.commandStop();
                }
            }), new PingCommand(), new ExitCommand(), new HaltCommand()).start();
        }
    }

    private void maybeEnableShutdownIfNotAlive() throws IOException {
        String port = this.getProperty(KeepAliveThread.KEEP_ALIVE_PORT, null);
        if (port != null) {
            String pingInterval = this.getProperty(KeepAliveThread.KEEP_ALIVE_PING_INTERVAL, FIVE_SECONDS);
            String timeout = this.getProperty(KeepAliveThread.KEEP_ALIVE_TIMEOUT, ONE_SECOND);
            new KeepAliveThread("127.0.0.1", Integer.parseInt(port), Integer.parseInt(pingInterval), Integer.parseInt(timeout)).start();
        }
    }

    public void commandStop() {
        ShutdownHelper.exit(0);
    }

    public void stop() throws Exception {
        this.server.stop();
    }

    public static void main(String[] args) throws Exception {
        MDC.put((String)"userId", (String)SYSTEM_USERID);
        new Launcher(null, null, args).start();
    }
}

