/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.bootstrap;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.bootstrap.ConfigurationBuilder;

public class EnvironmentVariables
implements ConfigurationBuilder.Customizer {
    private static final Logger log = LoggerFactory.getLogger(EnvironmentVariables.class);

    @Override
    public void apply(ConfigurationBuilder builder) throws Exception {
        this.maybeSetLegacy(builder, "application-host", "PLEXUS_APPLICATION_HOST");
        this.maybeSetLegacy(builder, "application-port", "PLEXUS_APPLICATION_PORT");
        this.maybeSetLegacy(builder, "nexus-work", "PLEXUS_NEXUS_WORK");
        this.maybeSetLegacy(builder, "nexus-webapp-context-path", "PLEXUS_CONTEXT_PATH");
        this.maybeSet(builder, "application-host", "NEXUS_APPLICATION_HOST");
        this.maybeSet(builder, "application-port", "NEXUS_APPLICATION_PORT");
        this.maybeSet(builder, "nexus-work", "NEXUS_WORK");
        this.maybeSet(builder, "nexus-webapp-context-path", "NEXUS_CONTEXT_PATH");
    }

    private boolean maybeSet(ConfigurationBuilder builder, String property, String env) {
        String value = System.getenv(env);
        if (value != null) {
            log.debug("Environment variable: {}={}", (Object)env, (Object)value);
            builder.set(property, value);
            return true;
        }
        return false;
    }

    private void maybeSetLegacy(ConfigurationBuilder builder, String property, String env) {
        if (this.maybeSet(builder, property, env)) {
            log.warn("Detected legacy environment variable: {}", (Object)env);
        }
    }
}

