/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.rrb.parsers;

import java.util.ArrayList;
import org.codehaus.plexus.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.plugins.rrb.RepositoryDirectory;
import org.sonatype.nexus.plugins.rrb.parsers.RemoteRepositoryParser;

public class S3RemoteRepositoryParser
implements RemoteRepositoryParser {
    private final Logger logger = LoggerFactory.getLogger(S3RemoteRepositoryParser.class);
    private static final String[] EXCLUDES = new String[]{"VolumeIcon", "Parent Directory", "?", "..", "index", "robots"};
    private String localUrl;
    private String remotePath;
    ArrayList<RepositoryDirectory> result = new ArrayList();

    public S3RemoteRepositoryParser(String remotePath, String localUrl, String id, String basePrefix) {
        this.remotePath = remotePath;
        this.localUrl = localUrl;
        if (localUrl.endsWith(remotePath)) {
            this.localUrl = localUrl.substring(0, localUrl.lastIndexOf(remotePath));
        }
        if (!this.localUrl.endsWith("/")) {
            this.localUrl = this.localUrl + "/";
        }
        if (!this.remotePath.endsWith("/")) {
            this.remotePath = this.remotePath + "/";
        }
    }

    void extractContent(StringBuilder indata, String prefix) {
        int start = 0;
        int end = 0;
        do {
            RepositoryDirectory rp = new RepositoryDirectory();
            StringBuilder temp = new StringBuilder();
            if ((start = indata.indexOf("<Key", start)) < 0) break;
            end = indata.indexOf("/Key>", start) + 5;
            temp.append(indata.subSequence(start, end));
            if (this.exclude(temp, prefix)) continue;
            String relativePath = this.removePrefix(this.getKeyName(temp), prefix).replace("//", "/");
            if (relativePath.startsWith("/")) {
                // empty if block
            }
            relativePath = relativePath.replaceFirst("/", "");
            rp.setLeaf(true);
            rp.setText(this.getText(relativePath));
            rp.setResourceURI(this.localUrl + relativePath);
            rp.setRelativePath("/" + relativePath);
            if (this.remotePath.endsWith(rp.getRelativePath().substring(1))) continue;
            this.logger.debug("addning {} to result", (Object)rp.toString());
            this.result.add(rp);
        } while ((start = end + 1) > 0);
    }

    void extractCommonPrefix(StringBuilder indata, String prefix) {
        int start = 0;
        int end = 0;
        do {
            RepositoryDirectory rp = new RepositoryDirectory();
            StringBuilder temp = new StringBuilder();
            if ((start = indata.indexOf("<CommonP", start)) < 0) break;
            end = indata.indexOf("/CommonP", start) + 8;
            temp.append(indata.subSequence(start, end));
            if (this.exclude(temp, prefix)) continue;
            String relativePath = this.getRelitivePath(temp, prefix);
            rp.setLeaf(false);
            rp.setText(this.getText(relativePath));
            rp.setResourceURI(this.localUrl + relativePath);
            rp.setRelativePath("/" + relativePath);
            this.result.add(rp);
        } while ((start = end + 1) > 0);
    }

    private String removePrefix(String localUrl, String prefix) {
        if (prefix == null) {
            return localUrl;
        }
        return localUrl.replaceFirst(prefix, "");
    }

    private String getText(String keyName) {
        String returnValue = "";
        if (keyName.indexOf(47) != -1) {
            String[] keys = keyName.split("/");
            returnValue = keys[keys.length - 1];
        } else {
            returnValue = keyName;
        }
        return returnValue;
    }

    private boolean exclude(StringBuilder value, String prefix) {
        for (String s : EXCLUDES) {
            if (value.indexOf(s) <= 0) continue;
            this.logger.debug("{} is in EXCLUDES array", (Object)value);
            return true;
        }
        return S3RemoteRepositoryParser.xmlContainsString(value, prefix) || S3RemoteRepositoryParser.xmlContainsString(value, this.remotePath) || S3RemoteRepositoryParser.xmlContainsString(value, prefix + this.remotePath);
    }

    private static boolean xmlContainsString(StringBuilder xmlSnippet, String checkFor) {
        return StringUtils.isNotEmpty((String)checkFor) && (xmlSnippet.indexOf(">" + checkFor + "<") > 0 || xmlSnippet.indexOf(">" + checkFor + "/<") > 0);
    }

    private String getKeyName(StringBuilder temp) {
        int start = temp.indexOf(">") + 1;
        int end = temp.indexOf("</");
        return temp.substring(start, end);
    }

    private String getPrefix(StringBuilder temp) {
        if (temp.indexOf("<Prefix>") < 0) {
            return "";
        }
        int start = temp.indexOf("<Prefix>") + 8;
        int end = temp.indexOf("</Prefix");
        return temp.substring(start, end);
    }

    private String getRelitivePath(StringBuilder temp, String prefix) {
        int start = temp.indexOf("<Prefix>") + 8;
        int end = temp.indexOf("</Prefix");
        String relativePath = (this.remotePath + this.removePrefix(temp.substring(start, end), prefix)).replaceAll("//", "/");
        if (relativePath.startsWith("/")) {
            relativePath = relativePath.substring(1);
        }
        return relativePath;
    }

    @Override
    public ArrayList<RepositoryDirectory> extractLinks(StringBuilder indata) {
        String prefix = this.getPrefix(indata);
        this.extractContent(indata, prefix);
        this.extractCommonPrefix(indata, prefix);
        return this.result;
    }
}

