/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.rrb.parsers;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import org.codehaus.plexus.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.plugins.rrb.RepositoryDirectory;
import org.sonatype.nexus.plugins.rrb.parsers.RemoteRepositoryParser;

public class HtmlRemoteRepositoryParser
implements RemoteRepositoryParser {
    private static final String[] EXCLUDES = new String[]{">Skip to content<", ">Log in<", ">Products<", "Parent Directory", "?", ">../", ">..<", ">._.<", "-logo.png", ">Community<", ">Support<", ">Resources<", ">About us<", ">Downloads<", ">Documentation<", ">Resources<", ">About This Site<", ">Contact Us<", ">Legal Terms and Privacy Policy<", ">Log out<", ">IONA Technologies<", ">Site Index<", ">Skip to content<", ">Log In<"};
    private final Logger logger = LoggerFactory.getLogger(HtmlRemoteRepositoryParser.class);
    protected String localUrl;
    protected String remotePath;
    protected String linkStart = "<a ";
    protected String linkEnd = "/a>";
    protected String href = "href=\"";
    protected String id;
    protected String baseUrl;
    protected String basePath;

    public HtmlRemoteRepositoryParser(String remotePath, String localUrl, String id, String baseUrl) {
        this.remotePath = remotePath;
        this.localUrl = localUrl;
        this.id = id;
        this.baseUrl = baseUrl;
        try {
            this.basePath = new URI(baseUrl).getPath();
        }
        catch (URISyntaxException e) {
            this.basePath = null;
        }
    }

    @Override
    public ArrayList<RepositoryDirectory> extractLinks(StringBuilder indata) {
        ArrayList<RepositoryDirectory> result = new ArrayList<RepositoryDirectory>();
        if (indata.indexOf(this.linkStart.toUpperCase()) != -1) {
            this.linkStart = this.linkStart.toUpperCase();
            this.linkEnd = this.linkEnd.toUpperCase();
            this.href = this.href.toUpperCase();
        }
        int start = 0;
        int end = 0;
        if (!this.remotePath.endsWith("/")) {
            this.remotePath = this.remotePath + "/";
        }
        if (this.remotePath.equals("/")) {
            this.remotePath = "";
        }
        if (!this.localUrl.endsWith("/")) {
            this.localUrl = this.localUrl + "/";
        }
        do {
            RepositoryDirectory rp = new RepositoryDirectory();
            StringBuilder temp = new StringBuilder();
            if ((start = indata.indexOf(this.linkStart, start)) < 0) break;
            end = indata.indexOf(this.linkEnd, start) + this.linkEnd.length();
            temp.append(indata.subSequence(start, end));
            if (this.exclude(temp)) continue;
            if (!this.getLinkName(temp).trim().endsWith("/")) {
                rp.setLeaf(true);
            }
            rp.setText(this.getLinkName(temp).replace("/", "").trim());
            String linkUrl = this.getLinkUrl(temp);
            if (!StringUtils.isBlank((String)this.basePath) && linkUrl.startsWith(this.basePath)) {
                linkUrl = linkUrl.substring(this.basePath.length(), linkUrl.length());
                if (!StringUtils.isBlank((String)this.remotePath) && linkUrl.startsWith(this.remotePath)) {
                    linkUrl = linkUrl.substring(this.remotePath.length(), linkUrl.length());
                }
            }
            String uri = linkUrl.replace(this.baseUrl, this.localUrl);
            try {
                new URL(uri);
                uri = uri.startsWith(this.localUrl) ? uri : this.localUrl + uri;
            }
            catch (MalformedURLException e) {
                uri = this.localUrl + this.remotePath + uri;
            }
            rp.setResourceURI(uri);
            rp.setRelativePath(uri.replace(this.localUrl, ""));
            if (!rp.getRelativePath().startsWith("/")) {
                rp.setRelativePath("/" + rp.getRelativePath());
            }
            if (StringUtils.isNotEmpty((String)rp.getText())) {
                result.add(rp);
            }
            this.logger.debug("adding {} to result", (Object)rp.toString());
        } while ((start = end + 1) > 0);
        return result;
    }

    protected String getLinkName(StringBuilder temp) {
        int start = temp.indexOf(">") + 1;
        int end = temp.indexOf("</");
        return this.cleanup(temp.substring(start, end));
    }

    protected String cleanup(String value) {
        int start = value.indexOf(60);
        int end = value.indexOf(62);
        if (start != -1 && start < end) {
            String seq = value.substring(start, end + 1);
            value = value.replace(seq, "");
            this.cleanup(value);
        }
        return value.trim();
    }

    protected String getLinkUrl(StringBuilder temp) {
        int start = temp.indexOf(this.href) + this.href.length();
        int end = temp.indexOf("\"", start + 1);
        return temp.substring(start, end);
    }

    boolean exclude(StringBuilder value) {
        for (String s : EXCLUDES) {
            if (value.indexOf(s) <= 0) continue;
            this.logger.debug("{} is in EXCLUDES array", (Object)value);
            return true;
        }
        return false;
    }
}

