/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.rrb.parsers;

import java.util.ArrayList;
import org.sonatype.nexus.plugins.rrb.RepositoryDirectory;
import org.sonatype.nexus.plugins.rrb.parsers.HtmlRemoteRepositoryParser;

public class ArtifactoryRemoteRepositoryParser
extends HtmlRemoteRepositoryParser {
    static String artifactoryLinkPattern = "class=\"icon-link";
    static String startOfArtifactoryLink = "<a " + artifactoryLinkPattern;
    static String validRefStart = "href=\"http";
    static String folderLink = artifactoryLinkPattern + " folder";
    static String folderLinkMatchPattern = ".*" + folderLink + ".*";
    static String uriPrefixEnd = "/http";

    public ArtifactoryRemoteRepositoryParser(String remotePath, String localUrl, String id, String baseUrl) {
        super(remotePath, localUrl, id, baseUrl);
    }

    @Override
    public ArrayList<RepositoryDirectory> extractLinks(StringBuilder indata) {
        ArrayList<RepositoryDirectory> result = new ArrayList<RepositoryDirectory>();
        ArrayList<String> artifactoryLinks = this.extractArtifactoryLinks(indata);
        int uriPrefixEndPosition = this.localUrl.indexOf(uriPrefixEnd);
        String uriPrefix = "";
        if (uriPrefixEndPosition > 0) {
            uriPrefix = this.localUrl.substring(0, uriPrefixEndPosition) + "/";
        }
        for (String artifactoryLink : artifactoryLinks) {
            RepositoryDirectory repositoryDirectory = new RepositoryDirectory();
            String text = this.getLinkName(artifactoryLink).replace("/", "").trim();
            repositoryDirectory.setLeaf(!artifactoryLink.matches(folderLinkMatchPattern));
            repositoryDirectory.setText(text);
            repositoryDirectory.setResourceURI(this.getLinkUrl(artifactoryLink));
            repositoryDirectory.setRelativePath(this.getRelativePath(artifactoryLink));
            result.add(repositoryDirectory);
        }
        return result;
    }

    public ArrayList<String> extractArtifactoryLinks(StringBuilder indata) {
        int currentStartPosition;
        ArrayList<String> result = new ArrayList<String>();
        int endPosition = currentStartPosition = -1;
        while ((currentStartPosition = this.getNextArtifactoryAnchorPosition(indata, endPosition)) > 0) {
            endPosition = indata.indexOf(this.linkEnd, currentStartPosition) + this.linkEnd.length();
            String string = indata.substring(currentStartPosition, endPosition);
            if (!this.containsValidArtifactoryReference(string)) continue;
            result.add(string);
        }
        return result;
    }

    private boolean containsValidArtifactoryReference(String string) {
        return string.indexOf(validRefStart) > 0 && string.indexOf(">..<") < 0;
    }

    private int getNextArtifactoryAnchorPosition(StringBuilder indata, int lastEndPosition) {
        return indata.indexOf(startOfArtifactoryLink, lastEndPosition);
    }

    protected String getLinkName(String anchorString) {
        return this.getLinkName(new StringBuilder(anchorString));
    }

    private String getRelativePath(String anchorString) {
        String artifactoryUrl = this.getLinkUrl(new StringBuilder(anchorString));
        return artifactoryUrl.substring(this.baseUrl.length());
    }

    protected String getLinkUrl(String anchorString) {
        String relativePath = this.getRelativePath(anchorString);
        if (relativePath.startsWith("/")) {
            relativePath = relativePath.substring(1);
        }
        String url = !this.localUrl.endsWith("/") ? this.localUrl + "/" + relativePath : this.localUrl + relativePath;
        return url;
    }
}

