/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.rrb;

import com.google.common.base.Preconditions;
import com.thoughtworks.xstream.XStream;
import java.net.URLDecoder;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.http.client.HttpClient;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethodSignature;
import org.restlet.Context;
import org.restlet.data.Reference;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.apachehttpclient.Hc4Provider;
import org.sonatype.nexus.plugins.rrb.MavenRepositoryReader;
import org.sonatype.nexus.plugins.rrb.MavenRepositoryReaderResponse;
import org.sonatype.nexus.plugins.rrb.RepositoryDirectory;
import org.sonatype.nexus.proxy.NoSuchRepositoryException;
import org.sonatype.nexus.proxy.NoSuchResourceStoreException;
import org.sonatype.nexus.proxy.ResourceStore;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.repository.ProxyRepository;
import org.sonatype.nexus.proxy.storage.remote.http.QueryStringBuilder;
import org.sonatype.nexus.rest.AbstractResourceStoreContentPlexusResource;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;
import org.sonatype.plexus.rest.resource.PlexusResource;

@Path(value="/repositories/{repositoryId}/remotebrowser")
@Produces(value={"application/xml", "application/json"})
@Consumes(value={"application/xml", "application/json"})
@Named
@Singleton
public class RemoteBrowserResource
extends AbstractResourceStoreContentPlexusResource
implements PlexusResource {
    public static final String RESOURCE_URI = "/repositories/{repositoryId}/remotebrowser";
    private final Logger logger = LoggerFactory.getLogger(RemoteBrowserResource.class);
    private final QueryStringBuilder queryStringBuilder;
    private final Hc4Provider httpClientProvider;

    @Inject
    public RemoteBrowserResource(QueryStringBuilder queryStringBuilder, Hc4Provider httpClientProvider) {
        this.queryStringBuilder = (QueryStringBuilder)Preconditions.checkNotNull((Object)queryStringBuilder);
        this.httpClientProvider = (Hc4Provider)Preconditions.checkNotNull((Object)httpClientProvider);
        this.setRequireStrictChecking(false);
    }

    public Object getPayloadInstance() {
        return null;
    }

    public void configureXStream(XStream xstream) {
        super.configureXStream(xstream);
        xstream.alias("rrbresponse", MavenRepositoryReaderResponse.class);
        xstream.alias("node", RepositoryDirectory.class);
    }

    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor("/repositories/*/remotebrowser/**", "authcBasic,perms[nexus:browseremote]");
    }

    public String getResourceUri() {
        return RESOURCE_URI;
    }

    @GET
    @ResourceMethodSignature(output=MavenRepositoryReaderResponse.class)
    public Object get(Context context, Request request, Response response, Variant variant) throws ResourceException {
        String id = request.getAttributes().get("repositoryId").toString();
        ResourceStoreRequest storageItem = this.getResourceStoreRequest(request);
        String remotePath = null;
        try {
            remotePath = URLDecoder.decode(storageItem.getRequestPath().substring(1), "UTF-8");
        }
        catch (Exception e) {
            remotePath = storageItem.getRequestPath().substring(1);
        }
        try {
            ProxyRepository proxyRepository = (ProxyRepository)this.getUnprotectedRepositoryRegistry().getRepositoryWithFacet(id, ProxyRepository.class);
            HttpClient client = this.httpClientProvider.createHttpClient(proxyRepository.getRemoteStorageContext());
            MavenRepositoryReader mr = new MavenRepositoryReader(client, this.queryStringBuilder);
            MavenRepositoryReaderResponse data = new MavenRepositoryReaderResponse();
            String localUrl = this.createRemoteResourceReference(request, id, "").toString(false, false);
            List<RepositoryDirectory> result = mr.extract(remotePath, localUrl, proxyRepository, id);
            data.setData(result);
            this.logger.debug("return value is {}", (Object)data);
            return data;
        }
        catch (NoSuchRepositoryException e) {
            this.logger.warn("Could not find repository: " + id, (Throwable)e);
            throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Could not find repository: " + id, (Throwable)e);
        }
    }

    protected Reference createRemoteResourceReference(Request request, String repoId, String remoteUrl) {
        Reference repoRootRef = this.createRepositoryReference(request, repoId);
        return this.createReference(repoRootRef, "remotebrowser/" + remoteUrl);
    }

    protected ResourceStore getResourceStore(Request request) throws NoSuchResourceStoreException, ResourceException {
        return this.getUnprotectedRepositoryRegistry().getRepository(request.getAttributes().get("repositoryId").toString());
    }
}

