/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.rrb;

import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.apachehttpclient.Hc4Provider;
import org.sonatype.nexus.plugins.rrb.RepositoryDirectory;
import org.sonatype.nexus.plugins.rrb.parsers.ArtifactoryRemoteRepositoryParser;
import org.sonatype.nexus.plugins.rrb.parsers.HtmlRemoteRepositoryParser;
import org.sonatype.nexus.plugins.rrb.parsers.RemoteRepositoryParser;
import org.sonatype.nexus.plugins.rrb.parsers.S3RemoteRepositoryParser;
import org.sonatype.nexus.proxy.repository.ProxyRepository;
import org.sonatype.nexus.proxy.storage.remote.http.QueryStringBuilder;

public class MavenRepositoryReader {
    private final Logger logger = LoggerFactory.getLogger(MavenRepositoryReader.class);
    private final HttpClient client;
    private final QueryStringBuilder queryStringBuilder;
    private ProxyRepository proxyRepository;
    private String remotePath;
    private String remoteUrl;
    private String localUrl;
    private String id;

    public MavenRepositoryReader(HttpClient client, QueryStringBuilder queryStringBuilder) {
        this.client = (HttpClient)Preconditions.checkNotNull((Object)client);
        this.queryStringBuilder = (QueryStringBuilder)Preconditions.checkNotNull((Object)queryStringBuilder);
    }

    public List<RepositoryDirectory> extract(String remotePath, String localUrl, ProxyRepository proxyRepository, String id) {
        this.logger.debug("remotePath={}", (Object)remotePath);
        this.remotePath = remotePath;
        this.localUrl = localUrl;
        this.proxyRepository = proxyRepository;
        this.id = id;
        try {
            new URL(remotePath);
            this.remoteUrl = remotePath;
        }
        catch (MalformedURLException e) {
            String baseRemoteUrl = proxyRepository.getRemoteUrl();
            this.remoteUrl = !baseRemoteUrl.endsWith("/") && !remotePath.startsWith("/") ? baseRemoteUrl + "/" + remotePath : baseRemoteUrl + remotePath;
        }
        StringBuilder html = this.getContent();
        if (this.logger.isDebugEnabled()) {
            this.logger.trace(html.toString());
        }
        return this.parseResult(html);
    }

    private ArrayList<RepositoryDirectory> parseResult(StringBuilder indata) {
        RemoteRepositoryParser parser = null;
        String baseUrl = "";
        if (this.proxyRepository != null) {
            baseUrl = this.proxyRepository.getRemoteUrl();
        }
        if (indata.indexOf("<html ") != -1) {
            if (indata.indexOf("title=\"Artifactory\"") != -1) {
                this.logger.debug("is Artifactory repository");
                parser = new ArtifactoryRemoteRepositoryParser(this.remotePath, this.localUrl, this.id, baseUrl);
            } else {
                this.logger.debug("is html repository");
                parser = new HtmlRemoteRepositoryParser(this.remotePath, this.localUrl, this.id, baseUrl);
            }
        } else if (indata.indexOf("xmlns=\"http://s3.amazonaws.com/doc/2006-03-01/\"") != -1 || indata.indexOf("<?xml") != -1 && this.responseContainsError(indata)) {
            this.logger.debug("is S3 repository");
            if (this.responseContainsError(indata) && !this.responseContainsAccessDenied(indata)) {
                this.logger.debug("response from S3 repository contains error, need to find rootUrl");
                this.remoteUrl = this.findcreateNewUrl(indata);
                indata = this.getContent();
            } else if (this.responseContainsError(indata) && this.responseContainsAccessDenied(indata)) {
                this.logger.debug("response from S3 repository contains access denied response");
                indata = new StringBuilder();
            }
            parser = new S3RemoteRepositoryParser(this.remotePath, this.localUrl, this.id, baseUrl.replace(this.findRootUrl(indata), ""));
        } else {
            this.logger.debug("Found no matching parser, using default html parser");
            parser = new HtmlRemoteRepositoryParser(this.remotePath, this.localUrl, this.id, baseUrl);
        }
        return parser.extractLinks(indata);
    }

    private String maybeAppendQueryString(String url) {
        String queryString = this.queryStringBuilder.getQueryString(this.proxyRepository);
        if (StringUtils.isEmpty((String)queryString)) {
            return url;
        }
        String sep = url.contains("?") ? "&" : "?";
        return url + sep + queryString;
    }

    private String findcreateNewUrl(StringBuilder indata) {
        this.logger.debug("indata={}", (Object)indata.toString());
        String key = this.extracktKey(indata);
        String newUrl = "";
        if (!key.equals("")) {
            newUrl = this.findRootUrl(indata);
            newUrl = newUrl + "?prefix=" + key;
        }
        if (!newUrl.endsWith("/")) {
            newUrl = newUrl + "/";
        }
        newUrl = this.maybeAppendQueryString(newUrl);
        this.logger.debug("newUrl={}", (Object)newUrl);
        return newUrl;
    }

    private String findRootUrl(StringBuilder indata) {
        int end = this.remoteUrl.indexOf(this.extracktKey(indata));
        if (end > 0) {
            String newUrl = this.remoteUrl.substring(0, end);
            if (newUrl.indexOf(63) != -1) {
                newUrl = newUrl.substring(0, newUrl.indexOf(63));
            }
            return newUrl;
        }
        return this.remoteUrl;
    }

    private String extracktKey(StringBuilder indata) {
        String key = "";
        int start = indata.indexOf("<Key>");
        int end = indata.indexOf("</Key>");
        if (start > 0 && end > start) {
            key = indata.substring(start + 5, end);
        }
        return key;
    }

    private boolean responseContainsError(StringBuilder indata) {
        return indata.indexOf("<Error>") != -1 || indata.indexOf("<error>") != -1;
    }

    private boolean responseContainsAccessDenied(StringBuilder indata) {
        return indata.indexOf("<Code>AccessDenied</Code>") != -1 || indata.indexOf("<code>AccessDenied</code>") != -1;
    }

    private StringBuilder getContent() {
        StringBuilder buff = new StringBuilder();
        String sep = this.remoteUrl.contains("?") ? "&" : "?";
        String url = this.remoteUrl + sep + "delimiter=/";
        url = this.maybeAppendQueryString(url);
        HttpGet method = new HttpGet(url);
        try {
            this.logger.debug("Requesting: {}", (Object)method);
            BasicHttpContext httpContext = new BasicHttpContext();
            httpContext.setAttribute(Hc4Provider.HTTP_CTX_KEY_REPOSITORY, (Object)this.proxyRepository);
            HttpResponse response = this.client.execute((HttpUriRequest)method, (HttpContext)httpContext);
            int statusCode = response.getStatusLine().getStatusCode();
            this.logger.debug("Status code: {}", (Object)statusCode);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    buff.append(line).append("\n");
                }
            }
            Header serverHeader = response.getFirstHeader("Server");
            if (buff.length() == 0 && serverHeader != null && serverHeader.getValue().equalsIgnoreCase("AmazonS3") && this.remoteUrl.endsWith("/")) {
                this.remoteUrl = this.remoteUrl.substring(0, this.remoteUrl.length() - 1);
                return this.getContent();
            }
            return buff;
        }
        catch (Exception e) {
            this.logger.warn("Failed to get directory listing content", (Throwable)e);
            return buff;
        }
    }
}

