/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.ldap.usermanagement;

import com.google.common.base.Preconditions;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.security.ldap.dao.LdapDAOException;
import org.sonatype.security.ldap.dao.LdapUser;
import org.sonatype.security.ldap.dao.NoSuchLdapUserException;
import org.sonatype.security.ldap.realms.LdapManager;
import org.sonatype.security.usermanagement.AbstractReadOnlyUserManager;
import org.sonatype.security.usermanagement.DefaultUser;
import org.sonatype.security.usermanagement.RoleIdentifier;
import org.sonatype.security.usermanagement.User;
import org.sonatype.security.usermanagement.UserNotFoundException;
import org.sonatype.security.usermanagement.UserNotFoundTransientException;
import org.sonatype.security.usermanagement.UserSearchCriteria;
import org.sonatype.security.usermanagement.UserStatus;

@Singleton
@Named(value="LDAP")
public class LdapUserManager
extends AbstractReadOnlyUserManager {
    private final LdapManager ldapManager;

    @Inject
    public LdapUserManager(LdapManager ldapManager) {
        this.ldapManager = (LdapManager)Preconditions.checkNotNull((Object)ldapManager);
    }

    public User getUser(String userId) throws UserNotFoundException {
        if (this.isEnabled()) {
            try {
                return this.toPlexusUser(this.ldapManager.getUser(userId));
            }
            catch (NoSuchLdapUserException e) {
                this.log.debug("User: " + userId + " not found.", (Throwable)e);
            }
            catch (LdapDAOException e) {
                this.log.debug("User: " + userId + " not found, cause: " + e.getMessage(), (Throwable)e);
                throw new UserNotFoundTransientException(userId, e.getMessage(), (Throwable)e);
            }
        }
        throw new UserNotFoundException(userId);
    }

    public Set<String> listUserIds() {
        TreeSet<String> userIds = new TreeSet<String>();
        for (User User2 : this.listUsers()) {
            userIds.add(User2.getUserId());
        }
        return userIds;
    }

    public Set<User> listUsers() {
        TreeSet<User> users = new TreeSet<User>();
        if (this.isEnabled()) {
            try {
                SortedSet<LdapUser> ldapUsers = this.ldapManager.getAllUsers();
                for (LdapUser ldapUser : ldapUsers) {
                    users.add(this.toPlexusUser(ldapUser));
                }
            }
            catch (LdapDAOException e) {
                this.log.debug("Could not return LDAP users, LDAP Realm must not be configured.", (Throwable)e);
            }
        }
        return users;
    }

    private User toPlexusUser(LdapUser ldapUser) {
        DefaultUser user = new DefaultUser();
        String email = ldapUser.getEmail();
        if (email != null) {
            email = email.trim();
        }
        user.setEmailAddress(email);
        user.setName(ldapUser.getRealName());
        user.setUserId(ldapUser.getUsername());
        user.setSource("LDAP");
        user.setStatus(UserStatus.active);
        for (String roleId : ldapUser.getMembership()) {
            RoleIdentifier role = new RoleIdentifier("LDAP", roleId);
            user.addRole(role);
        }
        return user;
    }

    private boolean isEnabled() {
        return true;
    }

    public String getSource() {
        return "LDAP";
    }

    public Set<User> searchUsers(UserSearchCriteria criteria) {
        TreeSet<User> users = new TreeSet<User>();
        if (this.isEnabled()) {
            try {
                SortedSet<LdapUser> ldapUsers = this.ldapManager.searchUsers(criteria.getUserId(), criteria.getOneOfRoleIds());
                for (LdapUser ldapUser : ldapUsers) {
                    users.add(this.toPlexusUser(ldapUser));
                }
            }
            catch (LdapDAOException e) {
                this.log.debug("Could not return LDAP users, LDAP Realm must not be configured.", (Throwable)e);
            }
        }
        return this.filterListInMemeory(users, criteria);
    }

    public String getAuthenticationRealmName() {
        return "LdapAuthenticatingRealm";
    }
}

