/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.ldap.upgrade.cipher;

import com.google.common.base.Preconditions;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.inject.Named;
import javax.inject.Singleton;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64Encoder;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.nexus.util.SystemPropertiesHelper;
import org.sonatype.security.ldap.upgrade.cipher.PlexusCipher;
import org.sonatype.security.ldap.upgrade.cipher.PlexusCipherException;

@Singleton
@Named
public class DefaultPlexusCipher
implements PlexusCipher {
    private static final int SALT_SIZE = 8;
    private static final String STRING_ENCODING = "UTF8";
    private final String algorithm;
    private final int iterationCount;
    private final BouncyCastleProvider bouncyCastleProvider;

    public DefaultPlexusCipher() {
        this(new BouncyCastleProvider(), SystemPropertiesHelper.getString((String)"plexusCipher.algorithm", (String)"PBEWithSHAAnd128BitRC4"), SystemPropertiesHelper.getInteger((String)"plexusCipher.iterationCount", (int)23));
    }

    public DefaultPlexusCipher(BouncyCastleProvider bouncyCastleProvider, String algorithm, int iterationCount) {
        this.bouncyCastleProvider = (BouncyCastleProvider)Preconditions.checkNotNull((Object)bouncyCastleProvider);
        this.algorithm = (String)Preconditions.checkNotNull((Object)algorithm);
        this.iterationCount = iterationCount;
    }

    private Cipher init(String passPhrase, byte[] salt, boolean encrypt) throws PlexusCipherException {
        int mode = encrypt ? 1 : 2;
        try {
            PBEKeySpec keySpec = new PBEKeySpec(passPhrase.toCharArray());
            SecretKey key = SecretKeyFactory.getInstance(this.algorithm, (Provider)this.bouncyCastleProvider).generateSecret(keySpec);
            Cipher cipher = Cipher.getInstance(this.algorithm, (Provider)this.bouncyCastleProvider);
            PBEParameterSpec paramSpec = new PBEParameterSpec(salt, this.iterationCount);
            cipher.init(mode, (Key)key, paramSpec);
            return cipher;
        }
        catch (Exception e) {
            throw new PlexusCipherException(e);
        }
    }

    private byte[] getSalt(int saltSize) throws NoSuchAlgorithmException, NoSuchProviderException {
        SecureRandom sr = new SecureRandom();
        sr.setSeed(System.currentTimeMillis());
        return sr.generateSeed(saltSize);
    }

    @Override
    public String encrypt(String str, String passPhrase) throws PlexusCipherException {
        try {
            byte[] salt = this.getSalt(8);
            Cipher cipher = this.init(passPhrase, salt, true);
            byte[] utf8 = str.getBytes(STRING_ENCODING);
            byte[] enc = cipher.doFinal(utf8);
            Base64Encoder b64 = new Base64Encoder();
            byte saltLen = (byte)(salt.length & 0xFF);
            int encLen = enc.length;
            byte[] res = new byte[salt.length + encLen + 1];
            res[0] = saltLen;
            System.arraycopy(salt, 0, res, 1, saltLen);
            System.arraycopy(enc, 0, res, saltLen + 1, encLen);
            ByteArrayOutputStream bout = new ByteArrayOutputStream(res.length * 2);
            b64.encode(res, 0, res.length, (OutputStream)bout);
            return bout.toString(STRING_ENCODING);
        }
        catch (Exception e) {
            throw new PlexusCipherException(e);
        }
    }

    @Override
    public String encryptAndDecorate(String str, String passPhrase) throws PlexusCipherException {
        return this.decorate(this.encrypt(str, passPhrase));
    }

    @Override
    public String decrypt(String str, String passPhrase) throws PlexusCipherException {
        if (StringUtils.isEmpty((String)str)) {
            return str;
        }
        try {
            Base64Encoder decoder = new Base64Encoder();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            decoder.decode(str, (OutputStream)baos);
            byte[] res = baos.toByteArray();
            int saltLen = res[0] & 0xFF;
            if (saltLen != 8) {
                throw new Exception("default.plexus.cipher.encryptedStringCorruptedStructure");
            }
            if (res.length < saltLen + 2) {
                throw new Exception("default.plexus.cipher.encryptedStringCorruptedLength");
            }
            byte[] salt = new byte[saltLen];
            System.arraycopy(res, 1, salt, 0, saltLen);
            int decLen = res.length - saltLen - 1;
            if (decLen < 1) {
                throw new Exception("default.plexus.cipher.encryptedStringCorruptedSize");
            }
            byte[] dec = new byte[decLen];
            System.arraycopy(res, saltLen + 1, dec, 0, decLen);
            Cipher cipher = this.init(passPhrase, salt, false);
            byte[] utf8 = cipher.doFinal(dec);
            return new String(utf8, STRING_ENCODING);
        }
        catch (Exception e) {
            throw new PlexusCipherException(e);
        }
    }

    @Override
    public String decryptDecorated(String str, String passPhrase) throws PlexusCipherException {
        if (StringUtils.isEmpty((String)str)) {
            return str;
        }
        if (this.isEncryptedString(str)) {
            return this.decrypt(this.unDecorate(str), passPhrase);
        }
        return this.decrypt(str, passPhrase);
    }

    @Override
    public boolean isEncryptedString(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return false;
        }
        int start = str.indexOf(123);
        int stop = str.indexOf(125);
        return start != -1 && stop != -1 && stop > start + 1;
    }

    @Override
    public String unDecorate(String str) throws PlexusCipherException {
        if (!this.isEncryptedString(str)) {
            throw new PlexusCipherException("default.plexus.cipher.badEncryptedPassword");
        }
        int start = str.indexOf(123);
        int stop = str.indexOf(125);
        return str.substring(start + 1, stop);
    }

    @Override
    public String decorate(String str) {
        return '{' + (str == null ? "" : str) + '}';
    }
}

