/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.ldap.realms.tools;

import java.net.MalformedURLException;
import org.codehaus.plexus.util.StringUtils;

public class LdapURL {
    private String protocol;
    private String host;
    private int port;
    private String searchBase;

    public LdapURL(String protocol, String host, int port, String searchBase) throws MalformedURLException {
        if (StringUtils.isEmpty((String)protocol)) {
            throw new MalformedURLException("LDAP protocol can not be empty.");
        }
        if (StringUtils.isEmpty((String)host)) {
            throw new MalformedURLException("LDAP host can not be empty.");
        }
        if (port < 1) {
            throw new MalformedURLException("LDAP port is not a valid port.");
        }
        if (StringUtils.isEmpty((String)searchBase)) {
            throw new MalformedURLException("LDAP searchBase can not be empty.");
        }
        this.protocol = protocol;
        this.host = host;
        this.port = port;
        this.searchBase = searchBase;
    }

    public String toString() {
        return this.protocol + "://" + this.host + ":" + this.port + "/" + this.searchBase;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getSearchBase() {
        return this.searchBase;
    }

    public void setSearchBase(String searchBase) {
        this.searchBase = searchBase;
    }
}

