/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.ldap.realms.persist.model.io.xpp3;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;
import org.sonatype.security.ldap.realms.persist.model.CConnectionInfo;
import org.sonatype.security.ldap.realms.persist.model.CUserAndGroupAuthConfiguration;
import org.sonatype.security.ldap.realms.persist.model.CUserRoleMapping;
import org.sonatype.security.ldap.realms.persist.model.Configuration;

public class LdapConfigurationXpp3Writer {
    private static final String NAMESPACE = null;

    public void write(Writer writer, Configuration configuration) throws IOException {
        MXSerializer serializer = new MXSerializer();
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"  ");
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
        serializer.setOutput(writer);
        serializer.startDocument(configuration.getModelEncoding(), null);
        this.writeConfiguration(configuration, "ldapConfiguration", (XmlSerializer)serializer);
        serializer.endDocument();
    }

    public void write(OutputStream stream, Configuration configuration) throws IOException {
        MXSerializer serializer = new MXSerializer();
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"  ");
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
        serializer.setOutput(stream, configuration.getModelEncoding());
        serializer.startDocument(configuration.getModelEncoding(), null);
        this.writeConfiguration(configuration, "ldapConfiguration", (XmlSerializer)serializer);
        serializer.endDocument();
    }

    private void writeCConnectionInfo(CConnectionInfo cConnectionInfo, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (cConnectionInfo.getSearchBase() != null) {
            serializer.startTag(NAMESPACE, "searchBase").text(cConnectionInfo.getSearchBase()).endTag(NAMESPACE, "searchBase");
        }
        if (cConnectionInfo.getSystemUsername() != null) {
            serializer.startTag(NAMESPACE, "systemUsername").text(cConnectionInfo.getSystemUsername()).endTag(NAMESPACE, "systemUsername");
        }
        if (cConnectionInfo.getSystemPassword() != null) {
            serializer.startTag(NAMESPACE, "systemPassword").text(cConnectionInfo.getSystemPassword()).endTag(NAMESPACE, "systemPassword");
        }
        if (cConnectionInfo.getAuthScheme() != null) {
            serializer.startTag(NAMESPACE, "authScheme").text(cConnectionInfo.getAuthScheme()).endTag(NAMESPACE, "authScheme");
        }
        if (cConnectionInfo.getProtocol() != null) {
            serializer.startTag(NAMESPACE, "protocol").text(cConnectionInfo.getProtocol()).endTag(NAMESPACE, "protocol");
        }
        if (cConnectionInfo.getHost() != null) {
            serializer.startTag(NAMESPACE, "host").text(cConnectionInfo.getHost()).endTag(NAMESPACE, "host");
        }
        if (cConnectionInfo.getPort() != 0) {
            serializer.startTag(NAMESPACE, "port").text(String.valueOf(cConnectionInfo.getPort())).endTag(NAMESPACE, "port");
        }
        if (cConnectionInfo.getRealm() != null) {
            serializer.startTag(NAMESPACE, "realm").text(cConnectionInfo.getRealm()).endTag(NAMESPACE, "realm");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeCUserAndGroupAuthConfiguration(CUserAndGroupAuthConfiguration cUserAndGroupAuthConfiguration, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (cUserAndGroupAuthConfiguration.getEmailAddressAttribute() != null) {
            serializer.startTag(NAMESPACE, "emailAddressAttribute").text(cUserAndGroupAuthConfiguration.getEmailAddressAttribute()).endTag(NAMESPACE, "emailAddressAttribute");
        }
        if (cUserAndGroupAuthConfiguration.isLdapGroupsAsRoles()) {
            serializer.startTag(NAMESPACE, "ldapGroupsAsRoles").text(String.valueOf(cUserAndGroupAuthConfiguration.isLdapGroupsAsRoles())).endTag(NAMESPACE, "ldapGroupsAsRoles");
        }
        if (cUserAndGroupAuthConfiguration.getGroupBaseDn() != null) {
            serializer.startTag(NAMESPACE, "groupBaseDn").text(cUserAndGroupAuthConfiguration.getGroupBaseDn()).endTag(NAMESPACE, "groupBaseDn");
        }
        if (cUserAndGroupAuthConfiguration.getGroupIdAttribute() != null) {
            serializer.startTag(NAMESPACE, "groupIdAttribute").text(cUserAndGroupAuthConfiguration.getGroupIdAttribute()).endTag(NAMESPACE, "groupIdAttribute");
        }
        if (cUserAndGroupAuthConfiguration.getGroupMemberAttribute() != null) {
            serializer.startTag(NAMESPACE, "groupMemberAttribute").text(cUserAndGroupAuthConfiguration.getGroupMemberAttribute()).endTag(NAMESPACE, "groupMemberAttribute");
        }
        if (cUserAndGroupAuthConfiguration.getGroupMemberFormat() != null) {
            serializer.startTag(NAMESPACE, "groupMemberFormat").text(cUserAndGroupAuthConfiguration.getGroupMemberFormat()).endTag(NAMESPACE, "groupMemberFormat");
        }
        if (cUserAndGroupAuthConfiguration.getGroupObjectClass() != null) {
            serializer.startTag(NAMESPACE, "groupObjectClass").text(cUserAndGroupAuthConfiguration.getGroupObjectClass()).endTag(NAMESPACE, "groupObjectClass");
        }
        if (cUserAndGroupAuthConfiguration.getUserPasswordAttribute() != null) {
            serializer.startTag(NAMESPACE, "userPasswordAttribute").text(cUserAndGroupAuthConfiguration.getUserPasswordAttribute()).endTag(NAMESPACE, "userPasswordAttribute");
        }
        if (cUserAndGroupAuthConfiguration.getPreferredPasswordEncoding() != null) {
            serializer.startTag(NAMESPACE, "preferredPasswordEncoding").text(cUserAndGroupAuthConfiguration.getPreferredPasswordEncoding()).endTag(NAMESPACE, "preferredPasswordEncoding");
        }
        if (cUserAndGroupAuthConfiguration.getUserIdAttribute() != null) {
            serializer.startTag(NAMESPACE, "userIdAttribute").text(cUserAndGroupAuthConfiguration.getUserIdAttribute()).endTag(NAMESPACE, "userIdAttribute");
        }
        if (cUserAndGroupAuthConfiguration.getUserObjectClass() != null) {
            serializer.startTag(NAMESPACE, "userObjectClass").text(cUserAndGroupAuthConfiguration.getUserObjectClass()).endTag(NAMESPACE, "userObjectClass");
        }
        if (cUserAndGroupAuthConfiguration.getUserBaseDn() != null) {
            serializer.startTag(NAMESPACE, "userBaseDn").text(cUserAndGroupAuthConfiguration.getUserBaseDn()).endTag(NAMESPACE, "userBaseDn");
        }
        if (cUserAndGroupAuthConfiguration.getUserRealNameAttribute() != null) {
            serializer.startTag(NAMESPACE, "userRealNameAttribute").text(cUserAndGroupAuthConfiguration.getUserRealNameAttribute()).endTag(NAMESPACE, "userRealNameAttribute");
        }
        if (cUserAndGroupAuthConfiguration.isUserSubtree()) {
            serializer.startTag(NAMESPACE, "userSubtree").text(String.valueOf(cUserAndGroupAuthConfiguration.isUserSubtree())).endTag(NAMESPACE, "userSubtree");
        }
        if (cUserAndGroupAuthConfiguration.isGroupSubtree()) {
            serializer.startTag(NAMESPACE, "groupSubtree").text(String.valueOf(cUserAndGroupAuthConfiguration.isGroupSubtree())).endTag(NAMESPACE, "groupSubtree");
        }
        if (cUserAndGroupAuthConfiguration.getUserMemberOfAttribute() != null) {
            serializer.startTag(NAMESPACE, "userMemberOfAttribute").text(cUserAndGroupAuthConfiguration.getUserMemberOfAttribute()).endTag(NAMESPACE, "userMemberOfAttribute");
        }
        if (cUserAndGroupAuthConfiguration.getLdapFilter() != null) {
            serializer.startTag(NAMESPACE, "ldapFilter").text(cUserAndGroupAuthConfiguration.getLdapFilter()).endTag(NAMESPACE, "ldapFilter");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeCUserRoleMapping(CUserRoleMapping cUserRoleMapping, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (cUserRoleMapping.getUserId() != null) {
            serializer.startTag(NAMESPACE, "userId").text(cUserRoleMapping.getUserId()).endTag(NAMESPACE, "userId");
        }
        if (cUserRoleMapping.getRoles() != null && cUserRoleMapping.getRoles().size() > 0) {
            serializer.startTag(NAMESPACE, "roles");
            for (String role : cUserRoleMapping.getRoles()) {
                serializer.startTag(NAMESPACE, "role").text(role).endTag(NAMESPACE, "role");
            }
            serializer.endTag(NAMESPACE, "roles");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeConfiguration(Configuration configuration, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (configuration.getVersion() != null) {
            serializer.startTag(NAMESPACE, "version").text(configuration.getVersion()).endTag(NAMESPACE, "version");
        }
        if (configuration.getConnectionInfo() != null) {
            this.writeCConnectionInfo(configuration.getConnectionInfo(), "connectionInfo", serializer);
        }
        if (configuration.getUserAndGroupConfig() != null) {
            this.writeCUserAndGroupAuthConfiguration(configuration.getUserAndGroupConfig(), "userAndGroupConfig", serializer);
        }
        if (configuration.getUserRoleMappings() != null && configuration.getUserRoleMappings().size() > 0) {
            serializer.startTag(NAMESPACE, "userRoleMappings");
            for (CUserRoleMapping o : configuration.getUserRoleMappings()) {
                this.writeCUserRoleMapping(o, "userRoleMapping", serializer);
            }
            serializer.endTag(NAMESPACE, "userRoleMappings");
        }
        serializer.endTag(NAMESPACE, tagName);
    }
}

