/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.ldap.realms.persist.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.sonatype.security.ldap.realms.persist.model.CConnectionInfo;
import org.sonatype.security.ldap.realms.persist.model.CUserAndGroupAuthConfiguration;
import org.sonatype.security.ldap.realms.persist.model.CUserRoleMapping;

public class Configuration
implements Serializable,
Cloneable {
    private String version = "2.8.0";
    private CConnectionInfo connectionInfo;
    private CUserAndGroupAuthConfiguration userAndGroupConfig;
    private List<CUserRoleMapping> userRoleMappings;
    private String modelEncoding = "UTF-8";
    public static final String MODEL_VERSION = "2.8.0";

    public void addUserRoleMapping(CUserRoleMapping cUserRoleMapping) {
        this.getUserRoleMappings().add(cUserRoleMapping);
    }

    public Configuration clone() {
        try {
            Configuration copy = (Configuration)super.clone();
            if (this.connectionInfo != null) {
                copy.connectionInfo = this.connectionInfo.clone();
            }
            if (this.userAndGroupConfig != null) {
                copy.userAndGroupConfig = this.userAndGroupConfig.clone();
            }
            if (this.userRoleMappings != null) {
                copy.userRoleMappings = new ArrayList<CUserRoleMapping>();
                for (CUserRoleMapping item : this.userRoleMappings) {
                    copy.userRoleMappings.add(item.clone());
                }
            }
            return copy;
        }
        catch (Exception ex) {
            throw (RuntimeException)new UnsupportedOperationException(this.getClass().getName() + " does not support clone()").initCause(ex);
        }
    }

    public CConnectionInfo getConnectionInfo() {
        return this.connectionInfo;
    }

    public String getModelEncoding() {
        return this.modelEncoding;
    }

    public CUserAndGroupAuthConfiguration getUserAndGroupConfig() {
        return this.userAndGroupConfig;
    }

    public List<CUserRoleMapping> getUserRoleMappings() {
        if (this.userRoleMappings == null) {
            this.userRoleMappings = new ArrayList<CUserRoleMapping>();
        }
        return this.userRoleMappings;
    }

    public String getVersion() {
        return this.version;
    }

    public void removeUserRoleMapping(CUserRoleMapping cUserRoleMapping) {
        this.getUserRoleMappings().remove(cUserRoleMapping);
    }

    public void setConnectionInfo(CConnectionInfo connectionInfo) {
        this.connectionInfo = connectionInfo;
    }

    public void setModelEncoding(String modelEncoding) {
        this.modelEncoding = modelEncoding;
    }

    public void setUserAndGroupConfig(CUserAndGroupAuthConfiguration userAndGroupConfig) {
        this.userAndGroupConfig = userAndGroupConfig;
    }

    public void setUserRoleMappings(List<CUserRoleMapping> userRoleMappings) {
        this.userRoleMappings = userRoleMappings;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}

