/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.ldap.realms.persist;

import java.util.ArrayList;
import java.util.List;
import org.sonatype.security.ldap.realms.persist.ValidationContext;
import org.sonatype.security.ldap.realms.persist.ValidationMessage;

public class ValidationResponse {
    private int key = 1;
    private boolean valid = true;
    private boolean modified = false;
    private List<ValidationMessage> validationErrors;
    private List<ValidationMessage> validationWarnings;
    private ValidationContext context;

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public List<ValidationMessage> getValidationErrors() {
        if (this.validationErrors == null) {
            this.validationErrors = new ArrayList<ValidationMessage>();
        }
        return this.validationErrors;
    }

    public ValidationMessage getValidationError(String key) {
        if (this.validationErrors != null) {
            for (ValidationMessage vm : this.validationErrors) {
                if (!vm.getKey().equals(key)) continue;
                return vm;
            }
        }
        return null;
    }

    public void setValidationErrors(List<ValidationMessage> validationErrors) {
        this.validationErrors = validationErrors;
        this.valid = validationErrors == null || validationErrors.size() == 0;
    }

    public void addValidationError(ValidationMessage message) {
        this.getValidationErrors().add(message);
        this.valid = false;
    }

    public void addValidationError(String message) {
        ValidationMessage e = new ValidationMessage(String.valueOf(this.key++), message);
        this.addValidationError(e);
    }

    public void addValidationError(String message, Throwable t) {
        ValidationMessage e = new ValidationMessage(String.valueOf(this.key++), message, t);
        this.addValidationError(e);
    }

    public ValidationMessage getValidationWarning(String key) {
        if (this.validationWarnings != null) {
            for (ValidationMessage vm : this.validationWarnings) {
                if (!vm.getKey().equals(key)) continue;
                return vm;
            }
        }
        return null;
    }

    public List<ValidationMessage> getValidationWarnings() {
        if (this.validationWarnings == null) {
            this.validationWarnings = new ArrayList<ValidationMessage>();
        }
        return this.validationWarnings;
    }

    public void setValidationWarnings(List<ValidationMessage> validationWarnings) {
        this.validationWarnings = validationWarnings;
    }

    public void addValidationWarning(ValidationMessage message) {
        this.getValidationWarnings().add(message);
    }

    public void addValidationWarning(String message) {
        ValidationMessage e = new ValidationMessage(String.valueOf(this.key++), message);
        this.addValidationWarning(e);
    }

    public void append(ValidationResponse response) {
        for (ValidationMessage msg : response.getValidationErrors()) {
            if (this.getValidationError(msg.getKey()) != null) {
                msg.setKey(msg.getKey() + "(" + this.key++ + ")");
            }
            this.addValidationError(msg);
        }
        for (ValidationMessage msg : response.getValidationWarnings()) {
            if (this.getValidationWarning(msg.getKey()) != null) {
                msg.setKey(msg.getKey() + "(" + this.key++ + ")");
            }
            this.addValidationWarning(msg);
        }
        this.setValid(this.isValid() && response.isValid());
        this.setModified(this.isModified() || response.isModified());
    }

    public void setContext(ValidationContext ctx) {
        this.context = ctx;
    }

    public ValidationContext getContext() {
        if (this.context == null) {
            this.context = new ValidationContext();
        }
        return this.context;
    }
}

