/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.ldap.realms.persist;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.security.ldap.realms.persist.PasswordHelper;
import org.sonatype.security.ldap.upgrade.cipher.PlexusCipher;
import org.sonatype.security.ldap.upgrade.cipher.PlexusCipherException;

@Singleton
@Named
public class DefaultPasswordHelper
implements PasswordHelper {
    private static final String ENC = "CMMDwoV";
    private final PlexusCipher plexusCipher;

    @Inject
    public DefaultPasswordHelper(PlexusCipher plexusCipher) {
        this.plexusCipher = (PlexusCipher)Preconditions.checkNotNull((Object)plexusCipher);
    }

    @Override
    public String encrypt(String password) throws PlexusCipherException {
        if (password != null) {
            return this.plexusCipher.encrypt(password, ENC);
        }
        return null;
    }

    @Override
    public String decrypt(String encodedPassword) throws PlexusCipherException {
        if (encodedPassword != null) {
            return this.plexusCipher.decrypt(encodedPassword, ENC);
        }
        return null;
    }
}

