/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.ldap.realms.persist;

import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.security.ldap.realms.persist.ConfigurationValidator;
import org.sonatype.security.ldap.realms.persist.ValidationContext;
import org.sonatype.security.ldap.realms.persist.ValidationMessage;
import org.sonatype.security.ldap.realms.persist.ValidationRequest;
import org.sonatype.security.ldap.realms.persist.ValidationResponse;
import org.sonatype.security.ldap.realms.persist.model.CConnectionInfo;
import org.sonatype.security.ldap.realms.persist.model.CUserAndGroupAuthConfiguration;
import org.sonatype.security.ldap.realms.persist.model.CUserRoleMapping;
import org.sonatype.security.ldap.realms.persist.model.Configuration;

@Singleton
@Named
public class DefaultLdapConfigurationValidator
implements ConfigurationValidator {
    @Override
    public ValidationResponse validateModel(ValidationRequest request) {
        ValidationResponse response = new ValidationResponse();
        Configuration configuration = request.getConfiguration();
        if (configuration == null) {
            ValidationMessage msg = new ValidationMessage("*", "Configuration is missing.");
            response.addValidationError(msg);
        } else {
            ValidationMessage msg;
            ValidationResponse vr;
            if (configuration.getConnectionInfo() != null) {
                vr = this.validateConnectionInfo(null, configuration.getConnectionInfo());
                this.mergeValidationResponse(vr, response);
            } else {
                msg = new ValidationMessage("*", "Connection Configuration is missing.");
                response.addValidationError(msg);
            }
            if (configuration.getUserAndGroupConfig() != null) {
                vr = this.validateUserAndGroupAuthConfiguration(null, configuration.getUserAndGroupConfig());
                this.mergeValidationResponse(vr, response);
            } else {
                msg = new ValidationMessage("*", "User And Group Configuration is missing.");
                response.addValidationError(msg);
            }
        }
        return response;
    }

    @Override
    public ValidationResponse validateConnectionInfo(ValidationContext ctx, CConnectionInfo connectionInfo) {
        ValidationMessage msg;
        ValidationResponse response = new ValidationResponse();
        if (StringUtils.isEmpty((String)connectionInfo.getHost())) {
            msg = new ValidationMessage("host", "Host cannot be empty.");
            response.addValidationError(msg);
        }
        if (StringUtils.isEmpty((String)connectionInfo.getAuthScheme())) {
            msg = new ValidationMessage("authScheme", "Authorization Scheme cannot be empty.");
            response.addValidationError(msg);
        }
        if (StringUtils.isEmpty((String)connectionInfo.getProtocol())) {
            msg = new ValidationMessage("protocol", "Protocol cannot be empty.");
            response.addValidationError(msg);
        }
        if (StringUtils.isEmpty((String)connectionInfo.getSearchBase())) {
            msg = new ValidationMessage("searchBase", "Search Base cannot be empty.");
            response.addValidationError(msg);
        }
        if (connectionInfo.getPort() < 1) {
            msg = new ValidationMessage("port", "Port cannot be empty.");
            response.addValidationError(msg);
        }
        if (StringUtils.isNotEmpty((String)connectionInfo.getAuthScheme()) && !connectionInfo.getAuthScheme().toLowerCase().equals("none")) {
            if (StringUtils.isEmpty((String)connectionInfo.getSystemUsername())) {
                msg = new ValidationMessage("systemUsername", "Username cannot be empty unless the 'Authorization Scheme' is 'Anonymous Authentication'.");
                response.addValidationError(msg);
            }
            if (StringUtils.isEmpty((String)connectionInfo.getSystemPassword())) {
                msg = new ValidationMessage("systemPassword", "Password cannot be empty unless the 'Authorization Scheme' is 'Anonymous Authentication'.");
                response.addValidationError(msg);
            }
        }
        return response;
    }

    @Override
    public ValidationResponse validateUserAndGroupAuthConfiguration(ValidationContext ctx, CUserAndGroupAuthConfiguration userAndGroupAuthConf) {
        ValidationMessage msg;
        ValidationResponse response = new ValidationResponse();
        if (StringUtils.isEmpty((String)userAndGroupAuthConf.getUserIdAttribute())) {
            msg = new ValidationMessage("userIdAttribute", "User ID Attribute cannot be empty.");
            response.addValidationError(msg);
        }
        if (StringUtils.isEmpty((String)userAndGroupAuthConf.getUserObjectClass())) {
            msg = new ValidationMessage("userObjectClass", "User Object Class cannot be empty.");
            response.addValidationError(msg);
        }
        if (StringUtils.isEmpty((String)userAndGroupAuthConf.getUserRealNameAttribute())) {
            msg = new ValidationMessage("userRealNameAttribute", "User Real Name Attribute cannot be empty.");
            response.addValidationError(msg);
        }
        if (StringUtils.isEmpty((String)userAndGroupAuthConf.getEmailAddressAttribute())) {
            msg = new ValidationMessage("emailAddressAttribute", "Email Address Attribute cannot be empty.");
            response.addValidationError(msg);
        }
        if (userAndGroupAuthConf.isLdapGroupsAsRoles() && StringUtils.isEmpty((String)userAndGroupAuthConf.getUserMemberOfAttribute())) {
            if (StringUtils.isEmpty((String)userAndGroupAuthConf.getGroupIdAttribute())) {
                msg = new ValidationMessage("groupIdAttribute", "Group ID Attribute cannot be empty when Use LDAP Groups as Roles is true.");
                response.addValidationError(msg);
            }
            if (StringUtils.isEmpty((String)userAndGroupAuthConf.getGroupMemberAttribute())) {
                msg = new ValidationMessage("groupMemberAttribute", "Group Member Attribute cannot be empty when Use LDAP Groups as Roles is true.");
                response.addValidationError(msg);
            }
            if (StringUtils.isEmpty((String)userAndGroupAuthConf.getGroupMemberFormat())) {
                msg = new ValidationMessage("groupMemberFormat", "Group Member Format cannot be empty when Use LDAP Groups as Roles is true.");
                response.addValidationError(msg);
            }
            if (StringUtils.isEmpty((String)userAndGroupAuthConf.getGroupObjectClass())) {
                msg = new ValidationMessage("groupObjectClass", "Group Object Class cannot be empty when Use LDAP Groups as Roles is true.");
                response.addValidationError(msg);
            }
        }
        return response;
    }

    public ValidationResponse validateUserRoleMapping(ValidationContext ctx, CUserRoleMapping userRoleMapping) {
        ValidationMessage msg;
        ValidationResponse response = new ValidationResponse();
        if (StringUtils.isEmpty((String)userRoleMapping.getUserId())) {
            msg = new ValidationMessage("userId", "UserId cannot be empty.");
            response.addValidationError(msg);
        }
        if (userRoleMapping == null || userRoleMapping.getRoles().size() == 0) {
            msg = new ValidationMessage("roles", "Roles cannot be empty.");
            response.addValidationError(msg);
        }
        return response;
    }

    protected ValidationResponse mergeValidationResponse(ValidationResponse source, ValidationResponse dest) {
        for (ValidationMessage message : source.getValidationErrors()) {
            dest.addValidationError(message);
        }
        for (ValidationMessage message : source.getValidationWarnings()) {
            dest.addValidationError(message);
        }
        return dest;
    }
}

