/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.ldap.realms.persist;

import com.google.common.base.Preconditions;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.configuration.application.ApplicationConfiguration;
import org.sonatype.security.ldap.realms.persist.AbstractLdapConfiguration;
import org.sonatype.security.ldap.realms.persist.ConfigurationValidator;
import org.sonatype.security.ldap.realms.persist.LdapClearCacheEvent;
import org.sonatype.security.ldap.realms.persist.LdapConfiguration;
import org.sonatype.security.ldap.realms.persist.PasswordHelper;
import org.sonatype.sisu.goodies.eventbus.EventBus;

@Singleton
@Named
public class DefaultLdapConfiguration
extends AbstractLdapConfiguration
implements LdapConfiguration {
    private final EventBus eventBus;

    @Inject
    public DefaultLdapConfiguration(ApplicationConfiguration applicationConfiguration, ConfigurationValidator validator, PasswordHelper passwordHelper, EventBus eventBus) throws IOException {
        super(applicationConfiguration, validator, passwordHelper);
        this.eventBus = (EventBus)Preconditions.checkNotNull((Object)eventBus);
    }

    @Override
    public void save() throws IOException {
        super.save();
        this.eventBus.post((Object)new LdapClearCacheEvent(this));
    }

    @Override
    public void clearCache() {
        super.clearCache();
        this.eventBus.post((Object)new LdapClearCacheEvent(null));
    }
}

