/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.ldap.realms.persist;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.concurrent.locks.ReentrantLock;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.sonatype.nexus.configuration.ModelUtils;
import org.sonatype.nexus.configuration.ModelloUtils;
import org.sonatype.nexus.configuration.application.ApplicationConfiguration;
import org.sonatype.security.ldap.dao.LdapAuthConfiguration;
import org.sonatype.security.ldap.realms.persist.ConfigurationValidator;
import org.sonatype.security.ldap.realms.persist.InvalidConfigurationException;
import org.sonatype.security.ldap.realms.persist.LdapConfiguration;
import org.sonatype.security.ldap.realms.persist.PasswordHelper;
import org.sonatype.security.ldap.realms.persist.ValidationRequest;
import org.sonatype.security.ldap.realms.persist.ValidationResponse;
import org.sonatype.security.ldap.realms.persist.model.CConnectionInfo;
import org.sonatype.security.ldap.realms.persist.model.CUserAndGroupAuthConfiguration;
import org.sonatype.security.ldap.realms.persist.model.Configuration;
import org.sonatype.security.ldap.realms.persist.model.io.xpp3.LdapConfigurationXpp3Reader;
import org.sonatype.security.ldap.realms.persist.model.io.xpp3.LdapConfigurationXpp3Writer;
import org.sonatype.security.ldap.upgrade.cipher.PlexusCipherException;
import org.sonatype.sisu.goodies.common.ComponentSupport;

public abstract class AbstractLdapConfiguration
extends ComponentSupport
implements LdapConfiguration {
    private final ConfigurationValidator validator;
    private final PasswordHelper passwordHelper;
    private final File configurationFile;
    private final LdapModelReader ldapModelReader;
    private final LdapModelWriter ldapModelWriter;
    private final ReentrantLock lock = new ReentrantLock();
    private Configuration configuration;

    public AbstractLdapConfiguration(ApplicationConfiguration applicationConfiguration, ConfigurationValidator validator, PasswordHelper passwordHelper) throws IOException {
        Preconditions.checkNotNull((Object)applicationConfiguration);
        this.validator = (ConfigurationValidator)Preconditions.checkNotNull((Object)validator);
        this.passwordHelper = (PasswordHelper)Preconditions.checkNotNull((Object)passwordHelper);
        this.configurationFile = new File(applicationConfiguration.getConfigurationDirectory(), "ldap.xml");
        this.ldapModelReader = new LdapModelReader();
        this.ldapModelWriter = new LdapModelWriter();
        this.configuration = this.load();
    }

    @Override
    public CConnectionInfo readConnectionInfo() {
        return this.getConfiguration().getConnectionInfo();
    }

    @Override
    public CUserAndGroupAuthConfiguration readUserAndGroupConfiguration() {
        return this.getConfiguration().getUserAndGroupConfig();
    }

    @Override
    public void updateUserAndGroupConfiguration(CUserAndGroupAuthConfiguration userAndGroupConfig) throws InvalidConfigurationException {
        this.lock.lock();
        try {
            ValidationResponse vr = this.validator.validateUserAndGroupAuthConfiguration(null, userAndGroupConfig);
            if (vr.getValidationErrors().size() > 0) {
                throw new InvalidConfigurationException(vr);
            }
            this.getConfiguration().setUserAndGroupConfig(userAndGroupConfig);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void updateConnectionInfo(CConnectionInfo connectionInfo) throws InvalidConfigurationException {
        this.lock.lock();
        try {
            ValidationResponse vr = this.validator.validateConnectionInfo(null, connectionInfo);
            if (vr.getValidationErrors().size() > 0) {
                throw new InvalidConfigurationException(vr);
            }
            this.getConfiguration().setConnectionInfo(connectionInfo);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected Configuration getConfiguration() {
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Configuration load() throws IOException {
        this.lock.lock();
        try {
            Configuration configuration = (Configuration)ModelloUtils.load((String)"2.8.0", (File)this.configurationFile, (ModelloUtils.ModelloModelReader)this.ldapModelReader, (ModelloUtils.ModelloModelUpgrader[])new ModelloUtils.ModelloModelUpgrader[]{new ModelloUtils.ModelloModelUpgrader("1.0.1", "2.8.0"){

                public void doUpgrade(Reader reader, Writer writer) throws IOException, XmlPullParserException {
                    Configuration conf = new LdapConfigurationXpp3Reader().read(reader);
                    conf.setVersion("2.8.0");
                    new LdapConfigurationXpp3Writer().write(writer, conf);
                }
            }});
            ValidationResponse vr = this.validator.validateModel(new ValidationRequest(configuration));
            if (vr.getValidationErrors().size() > 0) {
                this.log.warn("Invalid LDAP configuration, defaulting configuration", (Throwable)new InvalidConfigurationException(vr));
                configuration = this.getDefaultConfiguration();
            }
            if (configuration.getConnectionInfo() != null && StringUtils.isNotEmpty((String)configuration.getConnectionInfo().getSystemPassword())) {
                try {
                    configuration.getConnectionInfo().setSystemPassword(this.passwordHelper.decrypt(configuration.getConnectionInfo().getSystemPassword()));
                }
                catch (PlexusCipherException e) {
                    this.log.error("Failed to decrypt password, assuming the password in file: '" + this.configurationFile.getAbsolutePath() + "' is clear text.", (Throwable)e);
                }
            }
            Configuration configuration2 = configuration;
            return configuration2;
        }
        catch (FileNotFoundException e) {
            Configuration configuration = this.getDefaultConfiguration();
            return configuration;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void save() throws IOException {
        this.lock.lock();
        try {
            Configuration savedConfiguration = this.configuration.clone();
            if (savedConfiguration.getConnectionInfo() != null && StringUtils.isNotEmpty((String)savedConfiguration.getConnectionInfo().getSystemPassword())) {
                try {
                    savedConfiguration.getConnectionInfo().setSystemPassword(this.passwordHelper.encrypt(savedConfiguration.getConnectionInfo().getSystemPassword()));
                }
                catch (PlexusCipherException e) {
                    this.log.error("Failed to encrypt password while storing configuration file", (Throwable)e);
                }
            }
            this.log.debug("Saving configuration: {}", (Object)this.configurationFile);
            ModelloUtils.save((Object)savedConfiguration, (File)this.configurationFile, (ModelloUtils.ModelloModelWriter)this.ldapModelWriter);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void clearCache() {
        this.configuration = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Configuration getDefaultConfiguration() {
        Configuration defaultConfig = null;
        Reader fr = null;
        InputStream is = null;
        try {
            is = this.getClass().getResourceAsStream("/META-INF/realms/ldap.xml");
            LdapConfigurationXpp3Reader reader = new LdapConfigurationXpp3Reader();
            fr = new InputStreamReader(is);
            defaultConfig = reader.read(fr);
        }
        catch (IOException e) {
            this.log.error("Failed to read default LDAP Realm configuration.  This may be corrected while the application is running.", (Throwable)e);
            defaultConfig = new Configuration();
        }
        catch (XmlPullParserException e) {
            this.log.error("Failed to read default LDAP Realm configuration.  This may be corrected while the application is running.", (Throwable)e);
            defaultConfig = new Configuration();
        }
        finally {
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (IOException e) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return defaultConfig;
    }

    @Override
    public LdapAuthConfiguration getLdapAuthConfiguration() {
        CUserAndGroupAuthConfiguration userAndGroupsConf = this.readUserAndGroupConfiguration();
        LdapAuthConfiguration authConfig = new LdapAuthConfiguration();
        authConfig.setEmailAddressAttribute(userAndGroupsConf.getEmailAddressAttribute());
        authConfig.setUserBaseDn(StringUtils.defaultString((Object)userAndGroupsConf.getUserBaseDn(), (String)""));
        authConfig.setUserIdAttribute(userAndGroupsConf.getUserIdAttribute());
        authConfig.setUserObjectClass(userAndGroupsConf.getUserObjectClass());
        authConfig.setPasswordAttribute(userAndGroupsConf.getUserPasswordAttribute());
        authConfig.setUserRealNameAttribute(userAndGroupsConf.getUserRealNameAttribute());
        authConfig.setGroupBaseDn(StringUtils.defaultString((Object)userAndGroupsConf.getGroupBaseDn(), (String)""));
        authConfig.setGroupIdAttribute(userAndGroupsConf.getGroupIdAttribute());
        authConfig.setGroupMemberAttribute(userAndGroupsConf.getGroupMemberAttribute());
        authConfig.setGroupMemberFormat(userAndGroupsConf.getGroupMemberFormat());
        authConfig.setGroupObjectClass(userAndGroupsConf.getGroupObjectClass());
        authConfig.setUserSubtree(userAndGroupsConf.isUserSubtree());
        authConfig.setGroupSubtree(userAndGroupsConf.isGroupSubtree());
        authConfig.setUserMemberOfAttribute(userAndGroupsConf.getUserMemberOfAttribute());
        authConfig.setLdapGroupsAsRoles(userAndGroupsConf.isLdapGroupsAsRoles());
        authConfig.setLdapFilter(userAndGroupsConf.getLdapFilter());
        return authConfig;
    }

    private static class LdapModelWriter
    extends ModelloUtils.ModelloModelWriter<Configuration> {
        private final LdapConfigurationXpp3Writer modelloWriter = new LdapConfigurationXpp3Writer();

        private LdapModelWriter() {
        }

        public void write(Writer writer, Configuration model) throws IOException {
            model.setVersion("2.8.0");
            this.modelloWriter.write(writer, model);
        }
    }

    private static class LdapModelReader
    extends ModelloUtils.ModelloModelReader<Configuration>
    implements ModelUtils.Versioned {
        private final LdapConfigurationXpp3Reader modelloReader = new LdapConfigurationXpp3Reader();

        private LdapModelReader() {
        }

        public Configuration doRead(Reader reader) throws IOException, XmlPullParserException {
            return this.modelloReader.read(reader);
        }

        public String readVersion(InputStream input) throws IOException, ModelUtils.CorruptModelException {
            Throwable throwable = null;
            try (InputStreamReader r = new InputStreamReader(input, this.charset);){
                Xpp3Dom dom = Xpp3DomBuilder.build((Reader)r);
                Xpp3Dom versionNode = dom.getChild("version");
                if (versionNode != null) {
                    String originalFileVersion = versionNode.getValue();
                    if (Strings.isNullOrEmpty((String)originalFileVersion)) {
                        throw new ModelUtils.MissingModelVersionException("Passed in XML model have empty 'version' node");
                    }
                    String string = originalFileVersion;
                    return string;
                }
                String string = "1.0.1";
                return string;
            }
            catch (XmlPullParserException e) {
                try {
                    throw new ModelUtils.CorruptModelException("Passed in XML model cannot be parsed", (Throwable)e);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
    }
}

