/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.ldap.realms.connector;

import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.naming.NamingException;
import javax.naming.ldap.LdapContext;
import org.apache.commons.collections.CollectionUtils;
import org.apache.shiro.realm.ldap.LdapContextFactory;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.security.ldap.dao.LdapAuthConfiguration;
import org.sonatype.security.ldap.dao.LdapDAOException;
import org.sonatype.security.ldap.dao.LdapGroupDAO;
import org.sonatype.security.ldap.dao.LdapUser;
import org.sonatype.security.ldap.dao.LdapUserDAO;
import org.sonatype.security.ldap.dao.NoLdapUserRolesFoundException;
import org.sonatype.security.ldap.dao.NoSuchLdapGroupException;
import org.sonatype.security.ldap.dao.NoSuchLdapUserException;
import org.sonatype.security.ldap.realms.connector.LdapConnector;
import org.sonatype.sisu.goodies.common.ComponentSupport;

public class DefaultLdapConnector
extends ComponentSupport
implements LdapConnector {
    private LdapUserDAO ldapUserManager;
    private LdapGroupDAO ldapGroupManager;
    private LdapContextFactory ldapContextFactory;
    private LdapAuthConfiguration ldapAuthConfiguration;
    private String identifier;

    public DefaultLdapConnector(String identifier, LdapUserDAO ldapUserManager, LdapGroupDAO ldapGroupManager, LdapContextFactory ldapContextFactory, LdapAuthConfiguration ldapAuthConfiguration) {
        this.identifier = identifier;
        this.ldapUserManager = ldapUserManager;
        this.ldapGroupManager = ldapGroupManager;
        this.ldapContextFactory = ldapContextFactory;
        this.ldapAuthConfiguration = ldapAuthConfiguration;
    }

    @Override
    public Set<String> getUserRoles(String userId) throws LdapDAOException, NoLdapUserRolesFoundException {
        LdapContext context = null;
        try {
            context = this.getLdapContextFactory().getSystemLdapContext();
            Set<String> set = this.getUserRoles(userId, context, this.getLdapAuthConfiguration());
            return set;
        }
        catch (NamingException e) {
            String message = "Failed to retrieve ldap user roles for user" + userId;
            throw new LdapDAOException(message, e);
        }
        finally {
            this.closeContext(context);
        }
    }

    private Set<String> getUserRoles(String userId, LdapContext context, LdapAuthConfiguration conf) throws LdapDAOException, NoLdapUserRolesFoundException {
        HashSet<String> roles = new HashSet<String>();
        if (this.getLdapAuthConfiguration().isLdapGroupsAsRoles()) {
            roles.addAll(this.getGroupMembership(userId, context, conf));
        }
        return roles;
    }

    @Override
    public SortedSet<LdapUser> getAllUsers() throws LdapDAOException {
        return this.getUsers(-1);
    }

    @Override
    public SortedSet<LdapUser> getUsers(int count) throws LdapDAOException {
        LdapContext context = null;
        try {
            context = this.getLdapContextFactory().getSystemLdapContext();
            LdapAuthConfiguration conf = this.getLdapAuthConfiguration();
            SortedSet<LdapUser> users = this.ldapUserManager.getUsers(context, conf, count);
            if (DefaultLdapConnector.isStaticGroupMapping(conf)) {
                for (LdapUser ldapUser : users) {
                    this.updateGroupMembership(context, conf, ldapUser);
                }
            }
            SortedSet<LdapUser> sortedSet = users;
            return sortedSet;
        }
        catch (NamingException e) {
            String message = "Failed to retrieve ldap information for users.";
            throw new LdapDAOException(message, e);
        }
        finally {
            this.closeContext(context);
        }
    }

    @Override
    public LdapUser getUser(String username) throws NoSuchLdapUserException, LdapDAOException {
        LdapContext context = null;
        try {
            context = this.getLdapContextFactory().getSystemLdapContext();
            LdapAuthConfiguration conf = this.getLdapAuthConfiguration();
            LdapUser ldapUser = this.ldapUserManager.getUser(username, context, conf);
            if (DefaultLdapConnector.isStaticGroupMapping(conf)) {
                this.updateGroupMembership(context, conf, ldapUser);
            }
            LdapUser ldapUser2 = ldapUser;
            return ldapUser2;
        }
        catch (NamingException e) {
            String message = "Failed to retrieve ldap information for users.";
            throw new LdapDAOException(message, e);
        }
        finally {
            this.closeContext(context);
        }
    }

    @Override
    public SortedSet<LdapUser> searchUsers(String username, Set<String> roleIds) throws LdapDAOException {
        LdapContext context = null;
        try {
            context = this.getLdapContextFactory().getSystemLdapContext();
            LdapAuthConfiguration conf = this.getLdapAuthConfiguration();
            if (username == null) {
                username = "";
            }
            if (roleIds != null && !roleIds.isEmpty()) {
                if (!conf.isLdapGroupsAsRoles()) {
                    TreeSet<LdapUser> treeSet = new TreeSet<LdapUser>();
                    return treeSet;
                }
                if (DefaultLdapConnector.isStaticGroupMapping(conf) && CollectionUtils.intersection(roleIds, this.ldapGroupManager.getAllGroups(context, conf)).isEmpty()) {
                    TreeSet<LdapUser> treeSet = new TreeSet<LdapUser>();
                    return treeSet;
                }
            }
            SortedSet<LdapUser> users = this.ldapUserManager.getUsers(username + "*", context, conf, -1L);
            if (DefaultLdapConnector.isStaticGroupMapping(conf)) {
                for (LdapUser ldapUser : users) {
                    this.updateGroupMembership(context, conf, ldapUser);
                }
            }
            SortedSet<LdapUser> sortedSet = users;
            return sortedSet;
        }
        catch (NamingException e) {
            String message = "Failed to retrieve ldap information for users.";
            throw new LdapDAOException(message, e);
        }
        finally {
            this.closeContext(context);
        }
    }

    private static boolean isStaticGroupMapping(LdapAuthConfiguration conf) {
        return conf.isLdapGroupsAsRoles() && StringUtils.isEmpty((String)conf.getUserMemberOfAttribute());
    }

    private void updateGroupMembership(LdapContext context, LdapAuthConfiguration conf, LdapUser ldapUser) throws LdapDAOException {
        try {
            ldapUser.setMembership(this.getGroupMembership(ldapUser.getUsername(), context, conf));
        }
        catch (NoLdapUserRolesFoundException e) {
            this.log.debug("No roles found for user: " + ldapUser.getUsername());
        }
    }

    private Set<String> getGroupMembership(String username, LdapContext context, LdapAuthConfiguration conf) throws LdapDAOException, NoLdapUserRolesFoundException {
        return this.ldapGroupManager.getGroupMembership(username, context, conf);
    }

    @Override
    public SortedSet<String> getAllGroups() throws LdapDAOException {
        LdapContext context = null;
        try {
            TreeSet<String> results = new TreeSet<String>();
            context = this.getLdapContextFactory().getSystemLdapContext();
            LdapAuthConfiguration conf = this.getLdapAuthConfiguration();
            results.addAll(this.ldapGroupManager.getAllGroups(context, conf));
            TreeSet<String> treeSet = results;
            this.closeContext(context);
            return treeSet;
        }
        catch (NamingException e) {
            try {
                String message = "Failed to retrieve ldap information for users.";
                throw new LdapDAOException(message, e);
            }
            catch (Throwable throwable) {
                this.closeContext(context);
                throw throwable;
            }
        }
    }

    @Override
    public String getGroupName(String groupId) throws LdapDAOException, NoSuchLdapGroupException {
        LdapContext context = null;
        try {
            context = this.getLdapContextFactory().getSystemLdapContext();
            LdapAuthConfiguration conf = this.getLdapAuthConfiguration();
            String string = this.ldapGroupManager.getGroupName(groupId, context, conf);
            return string;
        }
        catch (NamingException e) {
            String message = "Failed to retrieve ldap information for users.";
            throw new LdapDAOException(message, e);
        }
        finally {
            this.closeContext(context);
        }
    }

    @Override
    public LdapContextFactory getLdapContextFactory() {
        return this.ldapContextFactory;
    }

    private LdapAuthConfiguration getLdapAuthConfiguration() {
        return this.ldapAuthConfiguration;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    private void closeContext(LdapContext context) {
        try {
            if (context != null) {
                context.close();
            }
        }
        catch (NamingException e) {
            this.log.debug("Error closing connection: " + e.getMessage(), (Throwable)e);
        }
    }
}

