/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.ldap.realms;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import org.apache.shiro.realm.ldap.LdapContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLdapContextFactory
implements LdapContextFactory {
    protected static final String SUN_CONNECTION_POOLING_ENV_PROPERTY = "com.sun.jndi.ldap.connect.pool";
    private static final Logger log = LoggerFactory.getLogger(DefaultLdapContextFactory.class);
    public static final String NEXUS_LDAP_ENV_PREFIX = "nexus.ldap.env.";
    protected String authentication = "simple";
    protected String principalSuffix = null;
    protected String searchBase = null;
    protected String contextFactoryClassName = "com.sun.jndi.ldap.LdapCtxFactory";
    protected String url = null;
    protected String referral = "follow";
    protected String systemUsername = null;
    protected String systemPassword = null;
    private boolean usePooling = true;
    private Map<String, String> additionalEnvironment;

    public DefaultLdapContextFactory() {
        HashMap envVars = Maps.newHashMap();
        for (String propertyName : System.getProperties().stringPropertyNames()) {
            if (!propertyName.startsWith(NEXUS_LDAP_ENV_PREFIX) || propertyName.length() <= NEXUS_LDAP_ENV_PREFIX.length()) continue;
            String key = propertyName.substring(NEXUS_LDAP_ENV_PREFIX.length());
            String value = System.getProperty(propertyName);
            if (value == null) continue;
            envVars.put(key, value);
        }
        if (!envVars.isEmpty()) {
            this.setAdditionalEnvironment(envVars);
        }
    }

    public void setAuthentication(String authentication) {
        this.authentication = authentication;
    }

    public void setPrincipalSuffix(String principalSuffix) {
        this.principalSuffix = principalSuffix;
    }

    public void setSearchBase(String searchBase) {
        this.searchBase = searchBase;
    }

    public void setContextFactoryClassName(String contextFactoryClassName) {
        this.contextFactoryClassName = contextFactoryClassName;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setReferral(String referral) {
        this.referral = referral;
    }

    public void setSystemUsername(String systemUsername) {
        this.systemUsername = systemUsername;
    }

    public void setSystemPassword(String systemPassword) {
        this.systemPassword = systemPassword;
    }

    public void setUsePooling(boolean usePooling) {
        this.usePooling = usePooling;
    }

    public void setAdditionalEnvironment(Map<String, String> additionalEnvironment) {
        this.additionalEnvironment = additionalEnvironment;
    }

    public void addAdditionalEnvironment(Map<String, String> additionalEnvironment) {
        if (this.additionalEnvironment == null) {
            this.additionalEnvironment = additionalEnvironment;
        } else {
            this.additionalEnvironment.putAll(additionalEnvironment);
        }
    }

    public LdapContext getSystemLdapContext() throws NamingException {
        return this.getLdapContext(this.systemUsername, this.systemPassword, true);
    }

    public LdapContext getLdapContext(String username, String password) throws NamingException {
        return this.getLdapContext(username, password, false);
    }

    public LdapContext getLdapContext(Object principal, Object credentials) throws NamingException {
        return this.getLdapContext(principal.toString(), credentials.toString(), false);
    }

    public LdapContext getLdapContext(String username, String password, boolean systemContext) throws NamingException {
        return new InitialLdapContext(this.getSetupEnvironment(username, password, systemContext), null);
    }

    @VisibleForTesting
    Hashtable<String, String> getSetupEnvironment(String username, String password, boolean systemContext) {
        Preconditions.checkNotNull((Object)this.url, (Object)"No ldap URL specified (ldap://<hostname>:<port>)");
        if (username != null && this.principalSuffix != null) {
            username = username + this.principalSuffix;
        }
        Hashtable<String, String> env = new Hashtable<String, String>();
        if (this.additionalEnvironment != null) {
            env.putAll(this.additionalEnvironment);
        }
        if ("none".equals(this.authentication) && !systemContext) {
            env.put("java.naming.security.authentication", "simple");
        } else {
            env.put("java.naming.security.authentication", this.authentication);
        }
        if (username != null) {
            env.put("java.naming.security.principal", username);
        }
        if (password != null) {
            env.put("java.naming.security.credentials", password);
        }
        env.put("java.naming.factory.initial", this.contextFactoryClassName);
        env.put("java.naming.provider.url", this.url);
        env.put("java.naming.referral", this.referral);
        if (this.usePooling && username != null && systemContext) {
            env.put(SUN_CONNECTION_POOLING_ENV_PROPERTY, "true");
        }
        if (log.isDebugEnabled()) {
            HashMap logEnv = Maps.newHashMap(env);
            if (logEnv.containsKey("java.naming.security.credentials")) {
                logEnv.put("java.naming.security.credentials", "***");
            }
            log.debug("Initializing LDAP context using URL [{}] and username [{}] with pooling [{}] and environment {}", new Object[]{this.url, this.systemUsername, this.usePooling ? "enabled" : "disabled", logEnv});
        }
        return env;
    }
}

