/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.ldap.realms;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.HashSet;
import java.util.Set;
import javax.naming.NamingException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authc.credential.AllowAllCredentialsMatcher;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.ldap.AbstractLdapRealm;
import org.apache.shiro.realm.ldap.LdapContextFactory;
import org.apache.shiro.subject.PrincipalCollection;
import org.slf4j.Logger;
import org.sonatype.security.authentication.AuthenticationException;
import org.sonatype.security.ldap.dao.LdapDAOException;
import org.sonatype.security.ldap.dao.NoLdapUserRolesFoundException;
import org.sonatype.security.ldap.realms.LdapManager;
import org.sonatype.sisu.goodies.common.Loggers;

public abstract class AbstractLdapAuthenticationRealm
extends AbstractLdapRealm {
    private final Logger logger = Loggers.getLogger(((Object)((Object)this)).getClass());
    private final LdapManager ldapManager;

    public AbstractLdapAuthenticationRealm(LdapManager ldapManager) {
        this.setName("LdapAuthenticatingRealm");
        this.ldapManager = (LdapManager)Preconditions.checkNotNull((Object)ldapManager);
    }

    protected AuthenticationInfo queryForAuthenticationInfo(AuthenticationToken token, LdapContextFactory ldapContextFactory) throws NamingException {
        UsernamePasswordToken upToken = (UsernamePasswordToken)token;
        String username = upToken.getUsername();
        String pass = String.valueOf(upToken.getPassword());
        if (Strings.isNullOrEmpty((String)pass)) {
            throw new org.apache.shiro.authc.AuthenticationException("Password must not be empty");
        }
        try {
            this.ldapManager.authenticateUser(username, pass);
            return this.buildAuthenticationInfo(username, null);
        }
        catch (AuthenticationException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("User: " + username + " could not be authenticated ", (Throwable)e);
            }
            throw new org.apache.shiro.authc.AuthenticationException(e.getMessage());
        }
    }

    protected AuthorizationInfo queryForAuthorizationInfo(PrincipalCollection principals, LdapContextFactory ldapContextFactory) throws NamingException {
        if (principals.getRealmNames().contains(this.getName())) {
            Set<Object> roles = new HashSet();
            String username = principals.getPrimaryPrincipal().toString();
            try {
                roles = this.ldapManager.getUserRoles(username);
            }
            catch (LdapDAOException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                throw new NamingException(e.getMessage());
            }
            catch (NoLdapUserRolesFoundException e) {
                this.logger.debug("User: " + username + " does not have any ldap roles.", (Throwable)e);
            }
            return new SimpleAuthorizationInfo(roles);
        }
        return null;
    }

    protected AuthenticationInfo buildAuthenticationInfo(String username, char[] password) {
        return new SimpleAuthenticationInfo((Object)username, (Object)password, this.getName());
    }

    public CredentialsMatcher getCredentialsMatcher() {
        return new AllowAllCredentialsMatcher();
    }
}

