/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.ldap.dao.password;

import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.security.ldap.dao.password.PasswordEncoder;

@Singleton
@Named(value="plain")
public class PlainPasswordEncoder
implements PasswordEncoder {
    @Override
    public String getMethod() {
        return "PLAIN";
    }

    @Override
    public String encodePassword(String password, Object salt) {
        return "{PLAIN}" + password;
    }

    @Override
    public boolean isPasswordValid(String encPassword, String inputPassword, Object salt) {
        String encryptedPassword = encPassword;
        if (encryptedPassword.startsWith("{PLAIN}") || encryptedPassword.startsWith("{plain}")) {
            encryptedPassword = encryptedPassword.substring("{plain}".length());
        }
        return inputPassword.equals(encryptedPassword);
    }
}

