/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.ldap.dao.password;

import java.io.ByteArrayInputStream;
import java.security.MessageDigest;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.shiro.codec.Hex;
import org.sonatype.security.ldap.dao.password.PasswordEncoder;

@Singleton
@Named(value="md5")
public class MD5PasswordEncoder
implements PasswordEncoder {
    @Override
    public String getMethod() {
        return "MD5";
    }

    @Override
    public String encodePassword(String password, Object salt) {
        return "{MD5}" + this.encodeString(password);
    }

    @Override
    public boolean isPasswordValid(String encPassword, String inputPassword, Object salt) {
        String encryptedPassword = this.stripHeader(encPassword);
        String check = this.stripHeader(this.encodePassword(inputPassword, salt));
        return check.equals(encryptedPassword);
    }

    protected String stripHeader(String encryptedPassword) {
        if (encryptedPassword.startsWith("{" + this.getMethod().toUpperCase() + "}") || encryptedPassword.startsWith("{" + this.getMethod().toLowerCase() + "}")) {
            encryptedPassword = encryptedPassword.substring("{MD5}".length());
        }
        return encryptedPassword;
    }

    protected String encodeString(String input) {
        ByteArrayInputStream is = new ByteArrayInputStream(input.getBytes());
        String result = null;
        try {
            int numRead;
            byte[] buffer = new byte[1024];
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            do {
                if ((numRead = is.read(buffer)) <= 0) continue;
                md5.update(buffer, 0, numRead);
            } while (numRead != -1);
            result = new String(Hex.encode((byte[])md5.digest()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }
}

