/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.ldap.dao.password;

import java.security.NoSuchAlgorithmException;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.security.ldap.dao.password.PasswordEncoder;
import org.sonatype.security.ldap.dao.password.hash.MD5Crypt;

@Singleton
@Named(value="crypt")
public class MD5CryptPasswordEncoder
implements PasswordEncoder {
    private final MD5Crypt md5Crypt = new MD5Crypt();

    @Override
    public String getMethod() {
        return "CRYPT";
    }

    @Override
    public String encodePassword(String password, Object salt) {
        try {
            return "{CRYPT}" + this.md5Crypt.crypt(password);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("No MD5 Algorithm", e);
        }
    }

    @Override
    public boolean isPasswordValid(String encPassword, String inputPassword, Object salt) {
        try {
            String encryptedPassword = encPassword;
            if (encryptedPassword.startsWith("{crypt}") || encryptedPassword.startsWith("{CRYPT}")) {
                encryptedPassword = encryptedPassword.substring("{crypt}".length());
            }
            int lastDollar = encryptedPassword.lastIndexOf(36);
            String realSalt = encryptedPassword.substring("$1$".length(), lastDollar);
            String check = this.md5Crypt.crypt(inputPassword, realSalt);
            return check.equals(encryptedPassword);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("No MD5 Algorithm", e);
        }
    }
}

