/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.ldap.dao.password;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.util.SystemPropertiesHelper;
import org.sonatype.security.ldap.dao.password.PasswordEncoder;
import org.sonatype.security.ldap.dao.password.PasswordEncoderManager;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Singleton
@Named
public class DefaultPasswordEncoderManager
extends ComponentSupport
implements PasswordEncoderManager {
    private static final Pattern ENCODING_SPEC_PATTERN = Pattern.compile("\\{([a-zA-Z0-9]+)\\}(.+)");
    private final String preferredEncoding = SystemPropertiesHelper.getString((String)"ldap.preferredEncoding", (String)"clear");
    private final Map<String, PasswordEncoder> encodersMap;

    @Inject
    public DefaultPasswordEncoderManager(Map<String, PasswordEncoder> encodersMap) {
        this.encodersMap = (Map)Preconditions.checkNotNull(encodersMap);
    }

    @Override
    public String encodePassword(String password, Object salt) {
        PasswordEncoder encoder = this.getPasswordEncoder(this.preferredEncoding);
        if (encoder == null) {
            throw new IllegalStateException("Preferred encoding has no associated PasswordEncoder.");
        }
        return encoder.encodePassword(password, salt);
    }

    @Override
    public boolean isPasswordValid(String encodedPassword, String password, Object salt) {
        if (encodedPassword == null) {
            return false;
        }
        String encoding = this.preferredEncoding;
        Matcher matcher = ENCODING_SPEC_PATTERN.matcher(encodedPassword);
        if (matcher.matches()) {
            encoding = matcher.group(1);
            encodedPassword = matcher.group(2);
        }
        PasswordEncoder encoder = this.getPasswordEncoder(encoding.toLowerCase());
        this.log.info("Verifying password with encoding: " + encoding + " (encoder: " + encoder + ").");
        if (encoder == null) {
            throw new IllegalStateException("Password encoding: " + encoding + " has no associated PasswordEncoder.");
        }
        return encoder.isPasswordValid(encodedPassword, password, salt);
    }

    @Override
    public String getPreferredEncoding() {
        return this.preferredEncoding;
    }

    private PasswordEncoder getPasswordEncoder(String encoding) {
        if (this.encodersMap.containsKey(encoding)) {
            return this.encodersMap.get(encoding);
        }
        return null;
    }
}

