/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.ldap.dao;

import java.util.HashSet;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.sonatype.security.ldap.dao.LdapDAOException;

public final class LdapUtils {
    private LdapUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getLabeledUriValue(Attributes attributes, String attrName, String label, String attributeDescription) throws LdapDAOException {
        Attribute attribute = attributes.get(attrName);
        if (attribute == null) return null;
        try (NamingEnumeration<?> attrs = attribute.getAll();){
            Object value;
            String val;
            do {
                if (!attrs.hasMoreElements()) return null;
            } while (!(val = String.valueOf(value = attrs.nextElement())).endsWith(" " + label));
            String string = val.substring(0, val.length() - (label.length() + 1));
            return string;
        }
        catch (NamingException e) {
            throw new LdapDAOException("Failed to retrieve " + attributeDescription + " (attribute: '" + attrName + "').", e);
        }
    }

    public static String getAttributeValue(Attributes attributes, String attrName, String attributeDescription) throws LdapDAOException {
        Attribute attribute = attributes.get(attrName);
        if (attribute != null) {
            try {
                Object value = attribute.get();
                return String.valueOf(value);
            }
            catch (NamingException e) {
                throw new LdapDAOException("Failed to retrieve " + attributeDescription + " (attribute: '" + attrName + "').", e);
            }
        }
        return null;
    }

    public static Set<String> getAttributeValues(Attributes attributes, String attrName, String attributeDescription) throws LdapDAOException {
        HashSet<String> results = new HashSet<String>();
        Attribute attribute = attributes.get(attrName);
        if (attribute != null) {
            try {
                NamingEnumeration<?> values = attribute.getAll();
                while (values.hasMoreElements()) {
                    results.add(String.valueOf(values.nextElement()));
                }
            }
            catch (NamingException e) {
                throw new LdapDAOException("Failed to retrieve " + attributeDescription + " (attribute: '" + attrName + "').", e);
            }
        }
        return results;
    }

    public static String getAttributeValueFromByteArray(Attributes attributes, String attrName, String attributeDescription) throws LdapDAOException {
        Attribute attribute;
        if (attrName != null && (attribute = attributes.get(attrName)) != null) {
            try {
                byte[] value = (byte[])attribute.get();
                return new String(value);
            }
            catch (NamingException e) {
                throw new LdapDAOException("Failed to retrieve " + attributeDescription + " (attribute: '" + attrName + "').", e);
            }
        }
        return null;
    }
}

