/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.ldap.dao;

import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.naming.InvalidNameException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.LdapName;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.security.ldap.dao.LdapAuthConfiguration;
import org.sonatype.security.ldap.dao.LdapDAOException;
import org.sonatype.security.ldap.dao.LdapUser;
import org.sonatype.security.ldap.dao.LdapUserDAO;
import org.sonatype.security.ldap.dao.LdapUtils;
import org.sonatype.security.ldap.dao.NoSuchLdapUserException;
import org.sonatype.security.ldap.dao.password.PasswordEncoderManager;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Singleton
@Named
public class DefaultLdapUserDAO
extends ComponentSupport
implements LdapUserDAO {
    private final PasswordEncoderManager passwordEncoderManager;

    @Inject
    public DefaultLdapUserDAO(PasswordEncoderManager passwordEncoderManager) {
        this.passwordEncoderManager = (PasswordEncoderManager)Preconditions.checkNotNull((Object)passwordEncoderManager);
    }

    @Override
    public PasswordEncoderManager getPasswordEncoderManager() {
        return this.passwordEncoderManager;
    }

    @Override
    public void removeUser(String username, LdapContext context, LdapAuthConfiguration configuration) throws NoSuchLdapUserException, LdapDAOException {
        this.log.info("Remove user: " + username);
        try {
            context = (LdapContext)context.lookup(StringUtils.defaultString((Object)configuration.getUserBaseDn(), (String)""));
            context.destroySubcontext(configuration.getUserIdAttribute() + "=" + username);
        }
        catch (NamingException e) {
            String message = "Failed to remove user: " + username;
            throw new LdapDAOException(message, e);
        }
    }

    @Override
    public void updateUser(LdapUser user, LdapContext context, LdapAuthConfiguration configuration) throws NoSuchLdapUserException, LdapDAOException {
        LdapContext userContext;
        LdapUser inLdap = this.getUser(user.getUsername(), context, configuration);
        String userIdAttribute = configuration.getUserIdAttribute();
        String userBaseDn = StringUtils.defaultString((Object)configuration.getUserBaseDn(), (String)"");
        try {
            userContext = (LdapContext)context.lookup(userBaseDn);
        }
        catch (NamingException e) {
            String message = "Failed to create user for: " + user.getUsername();
            throw new LdapDAOException(message, e);
        }
        BasicAttributes addAttrs = new BasicAttributes();
        BasicAttributes modAttrs = new BasicAttributes();
        if (!StringUtils.isEmpty((String)user.getRealName())) {
            if (inLdap.getRealName() == null) {
                addAttrs.put(configuration.getUserRealNameAttribute(), user.getRealName());
            } else if (!user.getRealName().equals(inLdap.getRealName())) {
                modAttrs.put(configuration.getUserRealNameAttribute(), user.getRealName());
            }
        }
        if (!StringUtils.isEmpty((String)user.getEmail())) {
            if (inLdap.getEmail() == null) {
                addAttrs.put(configuration.getEmailAddressAttribute(), user.getEmail());
            } else if (!user.getEmail().equals(inLdap.getEmail())) {
                modAttrs.put(configuration.getEmailAddressAttribute(), user.getEmail());
            }
        }
        if (!StringUtils.isEmpty((String)user.getWebsite())) {
            if (inLdap.getWebsite() == null) {
                if (configuration.isWebsiteAttributeLabelUri()) {
                    addAttrs.put(configuration.getWebsiteAttribute(), user.getWebsite() + " " + configuration.getWebsiteUriLabel());
                } else {
                    addAttrs.put(configuration.getWebsiteAttribute(), user.getWebsite());
                }
            } else if (!user.getWebsite().equals(inLdap.getWebsite())) {
                if (configuration.isWebsiteAttributeLabelUri()) {
                    modAttrs.put(configuration.getWebsiteAttribute(), user.getWebsite() + " " + configuration.getWebsiteUriLabel());
                } else {
                    modAttrs.put(configuration.getWebsiteAttribute(), user.getWebsite());
                }
            }
        }
        if (addAttrs.size() > 0) {
            try {
                userContext.modifyAttributes(userIdAttribute + "=" + user.getUsername(), 1, (Attributes)addAttrs);
            }
            catch (NamingException e) {
                String message = "Failed to update user: " + user.getUsername();
                throw new LdapDAOException(message, e);
            }
        }
        if (modAttrs.size() > 0) {
            try {
                userContext.modifyAttributes(userIdAttribute + "=" + user.getUsername(), 2, (Attributes)modAttrs);
            }
            catch (NamingException e) {
                String message = "Failed to update user: " + user.getUsername();
                throw new LdapDAOException(message, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changePassword(String username, String password, LdapContext context, LdapAuthConfiguration configuration) throws NoSuchLdapUserException, LdapDAOException {
        LdapContext userContext;
        String userIdAttribute = configuration.getUserIdAttribute();
        String userBaseDn = StringUtils.defaultString((Object)configuration.getUserBaseDn(), (String)"");
        String passwordAttribute = configuration.getPasswordAttribute();
        try (NamingEnumeration<SearchResult> existing = this.searchUsers(username, context, new String[]{userIdAttribute}, configuration, 1L);){
            if (!existing.hasMoreElements()) {
                throw new NoSuchLdapUserException(username);
            }
        }
        catch (NamingException e) {
            String message = "Error while checking for existing user: " + username;
            throw new LdapDAOException(message, e);
        }
        try {
            userContext = (LdapContext)context.lookup(userBaseDn);
        }
        catch (NamingException e) {
            String message = "Failed to change password for: " + username;
            throw new LdapDAOException(message, e);
        }
        BasicAttributes userAttrs = new BasicAttributes();
        userAttrs.put(passwordAttribute, this.passwordEncoderManager.encodePassword(password, null));
        try {
            userContext.modifyAttributes(userIdAttribute + "=" + username, 2, (Attributes)userAttrs);
        }
        catch (NamingException e) {
            String message = "Failed to update user for: " + username;
            throw new LdapDAOException(message);
        }
    }

    @Override
    public NamingEnumeration<SearchResult> searchUsers(String username, LdapContext context, LdapAuthConfiguration configuration, long limitCount) throws NamingException {
        return this.searchUsers(username, context, null, configuration, limitCount);
    }

    @Override
    public NamingEnumeration<SearchResult> searchUsers(LdapContext context, LdapAuthConfiguration configuration, long limitCount) throws NamingException {
        return this.searchUsers(null, context, null, configuration, limitCount);
    }

    @Override
    public NamingEnumeration<SearchResult> searchUsers(LdapContext context, String[] returnAttributes, LdapAuthConfiguration configuration, long limitCount) throws NamingException {
        return this.searchUsers(null, context, returnAttributes, configuration, limitCount);
    }

    @Override
    public NamingEnumeration<SearchResult> searchUsers(String username, LdapContext context, String[] returnAttributes, LdapAuthConfiguration configuration, long limitCount) throws NamingException {
        String[] userAttributes = returnAttributes;
        if (userAttributes == null) {
            userAttributes = configuration.getUserAttributes();
        }
        SearchControls ctls = new SearchControls();
        ctls.setDerefLinkFlag(true);
        ctls.setSearchScope(configuration.isUserSubtree() ? 2 : 1);
        ctls.setReturningAttributes(userAttributes);
        if (limitCount > 0L) {
            ctls.setCountLimit(limitCount);
        }
        String f = configuration.getLdapFilter();
        this.log.debug("Specific filter rule: \"" + (f != null ? f : "none") + "\"");
        String filter = "(&(objectClass=" + configuration.getUserObjectClass() + ")(" + configuration.getUserIdAttribute() + "=" + (username != null ? username : "*") + ")" + (f != null && !f.isEmpty() ? "(" + f + ")" : "") + ")";
        this.log.debug("Searching for users with filter: '" + filter + "'");
        String baseDN = StringUtils.defaultString((Object)configuration.getUserBaseDn(), (String)"");
        return context.search(baseDN, filter, ctls);
    }

    @Override
    public SortedSet<LdapUser> getUsers(LdapContext context, LdapAuthConfiguration configuration, long limitCount) throws LdapDAOException {
        return this.getUsers(null, context, configuration, limitCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedSet<LdapUser> getUsers(String username, LdapContext context, LdapAuthConfiguration configuration, long limitCount) throws LdapDAOException {
        TreeSet<LdapUser> treeSet;
        NamingEnumeration<SearchResult> results = this.searchUsers(username, context, configuration, limitCount);
        try {
            TreeSet<LdapUser> users = new TreeSet<LdapUser>();
            while (results.hasMoreElements()) {
                SearchResult result = (SearchResult)results.nextElement();
                users.add(this.createUser(result, configuration));
            }
            treeSet = users;
        }
        catch (Throwable throwable) {
            try {
                results.close();
                throw throwable;
            }
            catch (NamingException e) {
                String message = "Failed to retrieve ldap information for users.";
                throw new LdapDAOException(message, e);
            }
        }
        results.close();
        return treeSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createUser(LdapUser user, LdapContext context, LdapAuthConfiguration configuration) throws LdapDAOException {
        LdapContext userContext;
        String userIdAttribute = configuration.getUserIdAttribute();
        String userBaseDn = StringUtils.defaultString((Object)configuration.getUserBaseDn(), (String)"");
        try (NamingEnumeration<SearchResult> existing = this.searchUsers(user.getUsername(), context, new String[]{userIdAttribute}, configuration, 1L);){
            if (existing.hasMoreElements()) {
                throw new LdapDAOException("User: " + user.getUsername() + " already exists!");
            }
        }
        catch (NamingException e) {
            String message = "Error while checking for existing user: " + user.getUsername();
            throw new LdapDAOException(message, e);
        }
        try {
            userContext = (LdapContext)context.lookup(userBaseDn);
        }
        catch (NamingException e) {
            String message = "Failed to create user for: " + user.getUsername();
            throw new LdapDAOException(message, e);
        }
        BasicAttributes userAttrs = new BasicAttributes();
        if (!StringUtils.isEmpty((String)user.getPassword())) {
            userAttrs.put(configuration.getPasswordAttribute(), this.passwordEncoderManager.encodePassword(user.getPassword(), null));
        }
        if (!StringUtils.isEmpty((String)user.getRealName())) {
            userAttrs.put(configuration.getUserRealNameAttribute(), user.getRealName());
        }
        if (!StringUtils.isEmpty((String)user.getEmail())) {
            userAttrs.put(configuration.getEmailAddressAttribute(), user.getEmail());
        }
        if (!StringUtils.isEmpty((String)user.getWebsite())) {
            if (configuration.isWebsiteAttributeLabelUri()) {
                userAttrs.put(configuration.getWebsiteAttribute(), user.getWebsite() + " " + configuration.getWebsiteUriLabel());
            } else {
                userAttrs.put(configuration.getWebsiteAttribute(), user.getWebsite());
            }
        }
        try {
            userContext.createSubcontext(userIdAttribute + "=" + user.getUsername(), (Attributes)userAttrs);
        }
        catch (NamingException e) {
            String message = "Failed to create user for: " + user.getUsername();
            throw new LdapDAOException(message, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public LdapUser getUser(String username, LdapContext context, LdapAuthConfiguration configuration) throws NoSuchLdapUserException, LdapDAOException {
        this.log.debug("Searching for user: " + username);
        try (NamingEnumeration<SearchResult> result = this.searchUsers(username, context, null, configuration, 1L);){
            if (!result.hasMoreElements()) throw new NoSuchLdapUserException("A user with username '" + username + "' does not exist");
            LdapUser ldapUser = this.createUser((SearchResult)result.nextElement(), configuration);
            return ldapUser;
        }
        catch (NamingException e) {
            String message = "Failed to retrieve information for user: " + username;
            throw new LdapDAOException(message, e);
        }
    }

    private LdapUser createUser(SearchResult result, LdapAuthConfiguration configuration) throws LdapDAOException {
        Attributes attributes = result.getAttributes();
        LdapUser user = new LdapUser();
        String userIdAttribute = configuration.getUserIdAttribute();
        String emailAddressAttribute = configuration.getEmailAddressAttribute();
        String nameAttribute = configuration.getUserRealNameAttribute();
        String websiteAttribute = configuration.getWebsiteAttribute();
        String websiteUriLabel = configuration.getWebsiteUriLabel();
        String passwordAttribute = configuration.getPasswordAttribute();
        String memberOfAttribute = configuration.getUserMemberOfAttribute();
        user.setUsername(LdapUtils.getAttributeValue(attributes, userIdAttribute, "username"));
        user.setDn(result.getNameInNamespace());
        user.setEmail(LdapUtils.getAttributeValue(attributes, emailAddressAttribute, "email address"));
        user.setRealName(LdapUtils.getAttributeValue(attributes, nameAttribute, "name"));
        user.setPassword(LdapUtils.getAttributeValueFromByteArray(attributes, passwordAttribute, "password"));
        if (configuration.isWebsiteAttributeLabelUri()) {
            user.setWebsite(LdapUtils.getLabeledUriValue(attributes, websiteAttribute, websiteUriLabel, "website"));
        } else {
            user.setWebsite(LdapUtils.getAttributeValue(attributes, websiteAttribute, "website"));
        }
        if (configuration.isLdapGroupsAsRoles() && StringUtils.isNotEmpty((String)configuration.getUserMemberOfAttribute())) {
            Set<String> groups = LdapUtils.getAttributeValues(attributes, memberOfAttribute, "Member Of");
            HashSet<String> resolvedGroups = new HashSet<String>();
            for (String dnString : groups) {
                resolvedGroups.add(this.getGroupFromString(dnString));
            }
            user.setMembership(resolvedGroups);
        }
        return user;
    }

    private String getGroupFromString(String dnString) {
        String result = dnString;
        try {
            LdapName dn = new LdapName(dnString);
            result = String.valueOf(dn.getRdn(dn.size() - 1).getValue());
        }
        catch (InvalidNameException e) {
            this.log.debug("Expected a Group DN but found: " + dnString);
        }
        return result;
    }
}

