/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.ldap.dao;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.naming.InvalidNameException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.LdapName;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.security.ldap.LdapEncoder;
import org.sonatype.security.ldap.dao.LdapAuthConfiguration;
import org.sonatype.security.ldap.dao.LdapDAOException;
import org.sonatype.security.ldap.dao.LdapGroupDAO;
import org.sonatype.security.ldap.dao.LdapUser;
import org.sonatype.security.ldap.dao.LdapUserDAO;
import org.sonatype.security.ldap.dao.NoLdapUserRolesFoundException;
import org.sonatype.security.ldap.dao.NoSuchLdapGroupException;
import org.sonatype.security.ldap.dao.NoSuchLdapUserException;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Singleton
@Named
public class DefaultLdapGroupDAO
extends ComponentSupport
implements LdapGroupDAO {
    private final LdapUserDAO ldapUserManager;

    @Inject
    public DefaultLdapGroupDAO(LdapUserDAO ldapUserManager) {
        this.ldapUserManager = (LdapUserDAO)Preconditions.checkNotNull((Object)ldapUserManager);
    }

    private static boolean isGroupsEnabled(LdapAuthConfiguration configuration) {
        return configuration.isLdapGroupsAsRoles();
    }

    @Override
    public Set<String> getGroupMembership(String username, LdapContext context, LdapAuthConfiguration configuration) throws LdapDAOException, NoLdapUserRolesFoundException {
        boolean dynamicGroups = !StringUtils.isEmpty((String)configuration.getUserMemberOfAttribute());
        boolean groupsEnabled = DefaultLdapGroupDAO.isGroupsEnabled(configuration);
        Set<String> roleIds = new HashSet<String>();
        if (groupsEnabled) {
            if (!dynamicGroups) {
                roleIds = this.getGroupMembershipFromGroups(username, context, configuration);
            } else {
                try {
                    roleIds = this.getGroupMembershipFromUser(username, context, configuration);
                }
                catch (NoSuchLdapUserException e) {
                    throw new NoLdapUserRolesFoundException(username);
                }
            }
            if (roleIds == null | roleIds.isEmpty()) {
                throw new NoLdapUserRolesFoundException(username);
            }
        } else if (dynamicGroups && !groupsEnabled) {
            throw new NoLdapUserRolesFoundException(username);
        }
        return roleIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getAllGroups(LdapContext context, LdapAuthConfiguration configuration) throws LdapDAOException {
        Set<String> groups;
        block8: {
            groups = new HashSet<String>();
            if (DefaultLdapGroupDAO.isGroupsEnabled(configuration)) {
                try {
                    if (StringUtils.isEmpty((String)configuration.getUserMemberOfAttribute())) {
                        String groupIdAttribute = configuration.getGroupIdAttribute();
                        String groupBaseDn = StringUtils.defaultString((Object)configuration.getGroupBaseDn(), (String)"");
                        String filter = "(objectClass=" + configuration.getGroupObjectClass() + ")";
                        this.log.debug("Searching for groups in group DN: " + groupBaseDn + "\nUsing filter: '" + filter + "'");
                        SearchControls ctls = this.getBaseSearchControls(new String[]{groupIdAttribute}, configuration.isGroupSubtree());
                        try (NamingEnumeration<SearchResult> results = context.search(groupBaseDn, filter, ctls);){
                            groups = this.getGroupIdsFromSearch(results, groupIdAttribute, configuration);
                            break block8;
                        }
                    }
                    String memberOfAttribute = configuration.getUserMemberOfAttribute();
                    String filter = "(objectClass=" + configuration.getUserObjectClass() + ")";
                    SearchControls ctls = this.getBaseSearchControls(new String[]{memberOfAttribute}, true);
                    String userBaseDn = StringUtils.defaultString((Object)configuration.getUserBaseDn(), (String)"");
                    Set<String> roles = this.getGroupIdsFromSearch(context.search(userBaseDn, filter, ctls), memberOfAttribute, configuration);
                    for (String groupDN : roles) {
                        groups.add(this.getGroupFromString(groupDN));
                    }
                }
                catch (NamingException e) {
                    String message = "Failed to get list of groups.";
                    throw new LdapDAOException(message, e);
                }
            }
        }
        return groups;
    }

    private SearchControls getBaseSearchControls(String[] returningAttributes, boolean subtree) {
        SearchControls ctls = new SearchControls();
        ctls.setReturningAttributes(returningAttributes);
        ctls.setSearchScope(subtree ? 2 : 1);
        return ctls;
    }

    private Set<String> getGroupIdsFromSearch(NamingEnumeration searchResults, String groupIdAttribute, LdapAuthConfiguration configuration) throws NamingException {
        LinkedHashSet<String> roles = new LinkedHashSet<String>();
        Map<String, Set<String>> mappings = configuration.getGroupReverseMappings();
        while (searchResults.hasMoreElements()) {
            SearchResult result = (SearchResult)searchResults.nextElement();
            Attribute groupIdAttr = result.getAttributes().get(groupIdAttribute);
            if (groupIdAttr == null) continue;
            NamingEnumeration<?> attributes = groupIdAttr.getAll();
            while (attributes.hasMoreElements()) {
                String group = String.valueOf(attributes.nextElement());
                Set<String> mappedRoles = mappings.get(group);
                if (mappedRoles == null) {
                    roles.add(group);
                    continue;
                }
                roles.addAll(mappedRoles);
            }
        }
        return roles;
    }

    private Set<String> getGroupMembershipFromUser(String username, LdapContext context, LdapAuthConfiguration configuration) throws LdapDAOException, NoSuchLdapUserException {
        LdapUser user = this.ldapUserManager.getUser(username, context, configuration);
        return Collections.unmodifiableSet(user.getMembership());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getGroupMembershipFromGroups(String username, LdapContext context, LdapAuthConfiguration configuration) throws LdapDAOException {
        Set<String> set;
        String groupIdAttribute = configuration.getGroupIdAttribute();
        String groupMemberAttribute = configuration.getGroupMemberAttribute();
        String groupBaseDn = StringUtils.defaultString((Object)configuration.getGroupBaseDn(), (String)"");
        String groupMemberFormat = configuration.getGroupMemberFormat();
        String filter = "(&(objectClass={0})(&({1}=*)(";
        ArrayList<String> filterValues = new ArrayList<String>();
        filterValues.add(configuration.getGroupObjectClass());
        filterValues.add(groupIdAttribute);
        if (groupMemberFormat != null) {
            String member = StringUtils.replace((String)groupMemberFormat, (String)"${username}", (String)"{2}");
            if (groupMemberFormat.contains("${username}")) {
                filterValues.add(LdapEncoder.nameEncode(username));
            }
            if (groupMemberFormat.contains("${dn}")) {
                LdapUser user;
                try {
                    user = this.ldapUserManager.getUser(username, context, configuration);
                }
                catch (NoSuchLdapUserException e) {
                    String message = "Failed to retrieve role information from ldap for user: " + username;
                    throw new LdapDAOException(message, e);
                }
                member = StringUtils.replace((String)member, (String)"${dn}", (String)("{" + filterValues.size() + "}"));
                filterValues.add(user.getDn());
            }
            filter = filter + groupMemberAttribute + "=" + member + ")))";
        } else {
            filterValues.add(LdapEncoder.nameEncode(username));
            filter = filter + groupMemberAttribute + "={2})))";
        }
        this.log.debug("Searching for group membership of: " + username + " in group DN: " + groupBaseDn + "\nUsing filter: '" + filter + "'");
        SearchControls ctls = this.getBaseSearchControls(new String[]{groupIdAttribute}, configuration.isGroupSubtree());
        NamingEnumeration<SearchResult> results = context.search(groupBaseDn, filter, filterValues.toArray(), ctls);
        try {
            Set<String> roles;
            set = roles = this.getGroupIdsFromSearch(results, groupIdAttribute, configuration);
        }
        catch (Throwable throwable) {
            try {
                results.close();
                throw throwable;
            }
            catch (NamingException e) {
                String message = "Failed to retrieve role information from ldap for user: " + username;
                throw new LdapDAOException(message, e);
            }
        }
        results.close();
        return set;
    }

    private String getGroupFromString(String dnString) {
        String result = dnString;
        try {
            LdapName dn = new LdapName(dnString);
            result = String.valueOf(dn.getRdn(dn.size() - 1).getValue());
        }
        catch (InvalidNameException e) {
            this.log.debug("Expected a Group DN but found: " + dnString);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getGroupName(String groupId, LdapContext context, LdapAuthConfiguration configuration) throws LdapDAOException, NoSuchLdapGroupException {
        if (!DefaultLdapGroupDAO.isGroupsEnabled(configuration)) {
            throw new NoSuchLdapGroupException(groupId, groupId);
        }
        if (StringUtils.isEmpty((String)configuration.getUserMemberOfAttribute())) {
            Set<String> groups;
            String groupIdAttribute = configuration.getGroupIdAttribute();
            String groupBaseDn = StringUtils.defaultString((Object)configuration.getGroupBaseDn(), (String)"");
            String filter = "(&(objectClass=" + configuration.getGroupObjectClass() + ") (" + groupIdAttribute + "=" + groupId + "))";
            SearchControls ctls = this.getBaseSearchControls(new String[]{groupIdAttribute}, configuration.isGroupSubtree());
            try (NamingEnumeration<SearchResult> results = context.search(groupBaseDn, filter, ctls);){
                groups = this.getGroupIdsFromSearch(results, groupIdAttribute, configuration);
            }
            catch (NamingException e) {
                throw new LdapDAOException("Failed to find group: " + groupId, e);
            }
            if (groups.size() <= 0) {
                throw new NoSuchLdapGroupException(groupId, groupId);
            }
            if (groups.size() > 1) {
                throw new NoSuchLdapGroupException(groupId, "More then one group found for group: " + groupId);
            }
            return groups.iterator().next();
        }
        String memberOfAttribute = configuration.getUserMemberOfAttribute();
        String filter = "(objectClass=" + configuration.getUserObjectClass() + ")";
        SearchControls ctls = this.getBaseSearchControls(new String[]{memberOfAttribute}, true);
        String userBaseDn = StringUtils.defaultString((Object)configuration.getUserBaseDn(), (String)"");
        try {
            Set<String> roles = this.getGroupIdsFromSearch(context.search(userBaseDn, filter, ctls), memberOfAttribute, configuration);
            for (String groupDN : roles) {
                if (!groupId.equals(this.getGroupFromString(groupDN))) continue;
                return groupId;
            }
        }
        catch (NamingException e) {
            throw new LdapDAOException("Failed to find group: " + groupId, e);
        }
        throw new NoSuchLdapGroupException(groupId, groupId);
    }
}

