/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.ldap.dao;

import com.google.common.base.Preconditions;
import java.util.SortedSet;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.naming.NamingException;
import javax.naming.ldap.LdapContext;
import org.apache.shiro.realm.ldap.LdapContextFactory;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.security.ldap.dao.LdapAuthConfiguration;
import org.sonatype.security.ldap.dao.LdapConnectionTester;
import org.sonatype.security.ldap.dao.LdapDAOException;
import org.sonatype.security.ldap.dao.LdapGroupDAO;
import org.sonatype.security.ldap.dao.LdapUser;
import org.sonatype.security.ldap.dao.LdapUserDAO;
import org.sonatype.security.ldap.dao.NoLdapUserRolesFoundException;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Singleton
@Named
public class DefaultLdapConnectionTester
extends ComponentSupport
implements LdapConnectionTester {
    private final LdapUserDAO ldapUserDao;
    private final LdapGroupDAO ldapGroupDAO;

    @Inject
    public DefaultLdapConnectionTester(LdapUserDAO ldapUserDao, LdapGroupDAO ldapGroupDAO) {
        this.ldapUserDao = (LdapUserDAO)Preconditions.checkNotNull((Object)ldapUserDao);
        this.ldapGroupDAO = (LdapGroupDAO)Preconditions.checkNotNull((Object)ldapGroupDAO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testConnection(LdapContextFactory ldapContextFactory) throws NamingException {
        LdapContext ctx = null;
        try {
            ctx = ldapContextFactory.getSystemLdapContext();
            ctx.getAttributes("");
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException namingException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedSet<LdapUser> testUserAndGroupMapping(LdapContextFactory ldapContextFactory, LdapAuthConfiguration ldapAuthConfiguration, int numberOfResults) throws LdapDAOException, NamingException {
        LdapContext ctx = ldapContextFactory.getSystemLdapContext();
        try {
            SortedSet<LdapUser> users = this.ldapUserDao.getUsers(ctx, ldapAuthConfiguration, numberOfResults);
            if (ldapAuthConfiguration.isLdapGroupsAsRoles() && StringUtils.isEmpty((String)ldapAuthConfiguration.getUserMemberOfAttribute())) {
                for (LdapUser ldapUser : users) {
                    try {
                        ldapUser.setMembership(this.ldapGroupDAO.getGroupMembership(ldapUser.getUsername(), ctx, ldapAuthConfiguration));
                    }
                    catch (NoLdapUserRolesFoundException e) {
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug("While testing for user mapping user: " + ldapUser.getUsername() + " had no roles.");
                    }
                }
            }
            SortedSet<LdapUser> sortedSet = users;
            return sortedSet;
        }
        finally {
            try {
                ctx.close();
            }
            catch (NamingException namingException) {}
        }
    }
}

