/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.ldap.authorization;

import com.google.common.base.Preconditions;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.security.authorization.AbstractReadOnlyAuthorizationManager;
import org.sonatype.security.authorization.NoSuchPrivilegeException;
import org.sonatype.security.authorization.NoSuchRoleException;
import org.sonatype.security.authorization.Privilege;
import org.sonatype.security.authorization.Role;
import org.sonatype.security.ldap.dao.LdapDAOException;
import org.sonatype.security.ldap.dao.NoSuchLdapGroupException;
import org.sonatype.security.ldap.realms.LdapManager;

@Singleton
@Named(value="LDAP")
public class LdapAuthorizationManager
extends AbstractReadOnlyAuthorizationManager {
    private static final Logger logger = LoggerFactory.getLogger(LdapAuthorizationManager.class);
    private final LdapManager ldapManager;

    @Inject
    public LdapAuthorizationManager(LdapManager ldapManager) {
        this.ldapManager = (LdapManager)Preconditions.checkNotNull((Object)ldapManager);
    }

    public String getSource() {
        return "LDAP";
    }

    public Set<String> listRoleIds() {
        SortedSet<String> result = null;
        try {
            result = this.ldapManager.getAllGroups();
        }
        catch (LdapDAOException e) {
            logger.debug("Problem getting list of LDAP Groups: " + e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public Set<Role> listRoles() {
        TreeSet<Role> result = new TreeSet<Role>();
        try {
            for (String roleId : this.ldapManager.getAllGroups()) {
                Role role = new Role();
                role.setName(roleId);
                role.setRoleId(roleId);
                role.setSource(this.getSource());
                result.add(role);
            }
        }
        catch (LdapDAOException e) {
            logger.debug("Problem getting list of LDAP Groups: " + e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public Role getRole(String roleId) throws NoSuchRoleException {
        try {
            String roleName = this.ldapManager.getGroupName(roleId);
            if (roleName == null) {
                throw new NoSuchRoleException("Role: " + roleId + " was not found in LDAP.");
            }
            Role role = new Role();
            role.setName(roleId);
            role.setRoleId(roleId);
            role.setSource(this.getSource());
            return role;
        }
        catch (LdapDAOException e) {
            throw new NoSuchRoleException("Role: " + roleId + " was not found in LDAP.", (Throwable)e);
        }
        catch (NoSuchLdapGroupException e) {
            throw new NoSuchRoleException("Role: " + roleId + " was not found in LDAP.", (Throwable)e);
        }
    }

    public Set<Privilege> listPrivileges() {
        return null;
    }

    public Privilege getPrivilege(String privilegeId) throws NoSuchPrivilegeException {
        return null;
    }
}

