/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.security.ldap;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.naming.AuthenticationException;
import javax.naming.NamingException;
import javax.naming.ldap.LdapContext;
import org.apache.shiro.realm.ldap.LdapContextFactory;
import org.apache.shiro.realm.ldap.LdapUtils;
import org.sonatype.security.ldap.dao.LdapUser;
import org.sonatype.security.ldap.dao.password.PasswordEncoderManager;

@Singleton
@Named
public class LdapAuthenticator {
    private final PasswordEncoderManager passwordManager;

    @Inject
    public LdapAuthenticator(PasswordEncoderManager passwordManager) {
        this.passwordManager = (PasswordEncoderManager)Preconditions.checkNotNull((Object)passwordManager);
    }

    public void authenticateUserWithPassword(LdapUser ldapUser, String password) throws org.sonatype.security.authentication.AuthenticationException {
        if (!this.passwordManager.isPasswordValid(ldapUser.getPassword(), password, null)) {
            throw new org.sonatype.security.authentication.AuthenticationException("User '" + ldapUser.getUsername() + "' cannot be authenticated.");
        }
    }

    public void authenticateUserWithBind(LdapUser ldapUser, String password, LdapContextFactory ldapContextFactory, String authScheme) throws org.sonatype.security.authentication.AuthenticationException {
        String userId = ldapUser.getUsername();
        String bindUsername = ldapUser.getDn();
        if ("DIGEST-MD5".equals(authScheme) || "CRAM-MD5".equals(authScheme)) {
            bindUsername = userId;
        }
        this.checkPasswordUsingBind(ldapContextFactory, bindUsername, password);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkPasswordUsingBind(LdapContextFactory ldapContextFactory, String user, String pass) throws org.sonatype.security.authentication.AuthenticationException {
        LdapContext ctx = null;
        try {
            ctx = ldapContextFactory.getLdapContext(user, pass);
        }
        catch (AuthenticationException e) {
            try {
                throw new org.sonatype.security.authentication.AuthenticationException("User '" + user + "' cannot be authenticated.", (Throwable)e);
                catch (NamingException e2) {
                    throw new org.sonatype.security.authentication.AuthenticationException("User '" + user + "' cannot be authenticated.", (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                LdapUtils.closeContext(ctx);
                throw throwable;
            }
        }
        LdapUtils.closeContext((LdapContext)ctx);
    }
}

